#!/bin/sh
config() {
  NEW="$1"
  OLD="`dirname $NEW`/`basename $NEW .new`"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
     mv $NEW $OLD
  elif [ "`cat $OLD | md5sum`" = "`cat $NEW | md5sum`" ]; then # toss the redundant copy
     rm $NEW
  elif [ -r $OLD ] && [ "`basename $NEW .new`" == "menu" ] ; then
     mv $OLD $OLD.bak
     mv $NEW $OLD
  fi
# Otherwise, we leave the .new copy for the admin to consider...
}

#Check if the .fluxbox directory exist in the user HOME
if [ ! -d /root/.fluxbox ] ; then
   mkdir /root/.fluxbox
fi

if [ ! -d /root/.fluxbox/bgphotos ] ; then
   mkdir /root/.fluxbox/bgphotos
fi

if [ ! -d /root/.config ] ; then
   mkdir /root/.config
fi

if [ ! -d /root/.config/volumeicon ] ; then
   mkdir /root/.config/volumeicon
fi

if [ ! -d /root/.config/flash ] ; then
   mkdir /root/.config/flash
fi

if [ ! -d /root/.config/gchrome ] ; then
   mkdir /root/.config/gchrome
fi

if [ ! -d /root/.wicd ] ; then
   mkdir /root/.wicd
fi

#Remove files that might exist in /tmp matching out filenames!
if [ -f /tmp/startup.new ] ; then
   rm -f /tmp/startup.new
fi

if [ -f /tmp/menu.new ] ; then
   rm -f /tmp/menu.new
fi

if [ -f /tmp/autostart.sh.new ] ; then
   rm -f /tmp/autostart.sh.new
fi

if [ -f /tmp/update_imgs.new ] ; then
   rm -f /tmp/update_imgs.new
fi

if [ -f /tmp/keys.new ] ; then
   rm -f /tmp/keys.new
fi

if [ -f /tmp/config.new ] ; then
   rm -f /tmp/config.new
fi

if [ -f /tmp/volumeicon.new ] ; then
   rm -f /tmp/volumeicon.new
fi

if [ -f /tmp/flashplayer-plugin.SlackBuild.new ] ; then
   rm -f /tmp/flashplayer-plugin.SlackBuild.new
fi

if [ -f /tmp/slack-desc.new ] ; then
   rm -f /tmp/slack-desc.new
fi

config root/.fluxbox/startup.new
config root/.fluxbox/menu.new
config root/.fluxbox/keys.new
config root/.fluxbox/autostart.sh.new
config root/.fluxbox/update_imgs.new
config root/.config/volumeicon/volumeicon.new
config root/.config/flash/getflash.new
config root/.config/flash/flashplayer-plugin.SlackBuild.new
config root/.config/flash/slack-desc.new
config root/.config/gchrome/Preferences.new
config root/.config/gchrome/chrome.new
config root/.config/gchrome/getchrome.new
config root/.config/gchrome/google-chrome.SlackBuild.new
config root/.config/gchrome/slack-desc.new
config root/.config/gchrome/xdg-open.new
