#!/bin/sh
config() {
  NEW="$1"
  OLD="`dirname $NEW`/`basename $NEW .new`"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
     mv $NEW $OLD
  elif [ "`cat $OLD | md5sum`" = "`cat $NEW | md5sum`" ]; then # toss the redundant copy
     rm $NEW
  fi
# Otherwise, we leave the .new copy for the admin to consider...
}

#Check if the .xbmc/userdata directory exist in the user HOME
if [ ! -d /root/.xbmc ] ; then
   mkdir /root/.xbmc
fi

if [ ! -d /root/.xbmc/userdata ] ; then
   mkdir /root/.xbmc/userdata
fi

#Remove files that might exist in /tmp matching our filenames!
if [ -f /tmp/advancedsettings.xml.new ] ; then
   rm -f /tmp/advancedsettings.xml.new
fi

config root/.xbmc/userdata/advancedsettings.xml.new
