#!/bin/sh
config() {
  NEW="$1"
  OLD="`dirname $NEW`/`basename $NEW .new`"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
     mv $NEW $OLD
  elif [ "`basename $NEW`" == "rc.local.new" ] && [ "`grep startx $OLD`" == "" ] ; then
     echo "# SlaXBMC start-up variables" >> $OLD
     echo "# If you do not wish this to be executed then comment it out." >> $OLD
     echo "sh /etc/rc.d/rc.wicd \"start\" &" >> $OLD
     echo "sh /etc/rc.d/rc.lirc \"start\" &" >> $OLD
     echo "sh /etc/rc.d/rc.avahidaemon \"start\" &" >> $OLD
     echo "su - root -c startx &" >> $OLD
     echo "" >> $OLD
  elif [ "`basename $NEW`" == "default.pa.new" ] && [ "`grep combined $OLD`" == "" ] ; then
     echo "# SlaXBMC start-up variables" >> $OLD
     echo "# If you do not wish this to be executed then comment it out." >> $OLD
     echo "load-module module-combine-sink sink_name=combined" >> $OLD
     echo "set-default-sink combined" >> $OLD
     echo "" >> $OLD
  elif [ "`basename $NEW`" == "lilo.conf.new" ] && [ "`grep slaxbmc.bmp $OLD`" == "" ] ; then
     sed -i 's/slack.bmp/slaxbmc.bmp/g' $OLD
  elif [ "`basename $NEW`" == "liloconfig.new" ] && [ "`grep slaxbmc.bmp $OLD`" == "" ] ; then
     sed -i 's/OPTIONAL SLACKWARE LOGO BOOT/OPTIONAL SLAXBMC LOGO BOOT/g' $OLD
     sed -i 's/with the Slackware logo/with the SlaXBMC logo/g' $OLD
     sed -i 's!bitmap = /boot/slack.bmp!bitmap = /boot/slaxbmc.bmp!g' $OLD
  elif [ "`cat $OLD | md5sum`" = "`cat $NEW | md5sum`" ]; then # toss the redundant copy
     rm $NEW
  fi
# Otherwise, we leave the .new copy for the admin to consider...
}

# Remove files that might exist in /tmp matching out filenames!
if [ -f /tmp/default.pa.new ] ; then
   rm -f /tmp/default.pa.new
fi

if [ -f /tmp/rc.local.new ] ; then
   rm -f /tmp/rc.local.new
fi

if [ -f /tmp/smb.conf.new ] ; then
   rm -f /tmp/smb.conf.new
fi

if [ -f /tmp/alsa-base.conf.new ] ; then
   rm -f /tmp/alsa-base.conf.new
fi

if [ -f /tmp/.asoundrc.new ] ; then
   rm -f /tmp/.asoundrc.new
fi

if [ -f /tmp/.profile.new ] ; then
   rm -f /tmp/.profile.new
fi

if [ -f /tmp/.xinitrc.new ] ; then
   rm -f /tmp/.xinitrc.new
fi

if [ -f /tmp/slaxbmc.bmp.new ] ; then
   rm -f /tmp/slaxbmc.bmp.new
fi

config etc/pulse/default.pa.new
config etc/rc.d/rc.local.new
config etc/samba/smb.conf.new
config REPLACE/modprobe.d/alsa-base.conf.new
config root/.asoundrc.new
config root/.profile.new
config root/.xinitrc.new
config boot/slaxbmc.bmp.new

if [ -f /mnt/etc/passwd ] && [ -f /mnt/etc/shadow ] && [ -f /mnt/etc/group ] ; then
   echo "avahi:x:501:" >> /mnt/etc/group
   echo "pulse:x:502:" >> /mnt/etc/group
   echo "avahi:!:15605:0:99999:7:::" >> /mnt/etc/shadow
   echo "pulse:!:15605:0:99999:7:::" >> /mnt/etc/shadow
   echo "avahi:x:501:501:Avahi Daemon:/dev/null:/bin/false" >> /mnt/etc/passwd
   echo "pulse:x:502:502:PulseAudio:/dev/null:/bin/false" >> /mnt/etc/passwd
elif [ -f /etc/passwd ] && [ -f /etc/shadow ] && [ -f /etc/group ] ; then
   if [ "`grep avahi /etc/passwd`" == "" ] && [ "`grep avahi /etc/shadow`" == "" ] && [ "`grep avahi /etc/group`" == "" ] ; then
      echo "avahi:x:501:" >> /etc/group
      echo "avahi:!:15605:0:99999:7:::" >> /etc/shadow
      echo "avahi:x:501:501:Avahi Daemon:/dev/null:/bin/false" >> /etc/passwd
   fi
   if [ "`grep pulse /etc/passwd`" == "" ] && [ "`grep pulse /etc/shadow`" == "" ] && [ "`grep pulse /etc/group`" == "" ] ; then
      echo "pulse:x:502:" >> /etc/group
      echo "pulse:!:15605:0:99999:7:::" >> /etc/shadow
      echo "pulse:x:502:502:PulseAudio:/dev/null:/bin/false" >> /etc/passwd
   fi
fi
