# Welcome to I38 - Accessible i3 Window Manager

> **Note:** This help guide has been tailored to your specific configuration. You've chosen **BROWSER** as your web browser, **MODKEY** as your mod key, and you're using the **SCREENREADER** screen reader.

## Introduction to I38

I38 is a configuration for the i3 window manager that makes it more accessible for blind people. It features audio feedback, screen reader integration, and keyboard shortcuts designed for non-visual navigation.

Unlike traditional desktop environments like GNOME or MATE, i3 is a tiling window manager, which means windows are arranged in a non-overlapping layout. This can be more efficient to navigate by keyboard, as windows are organized in a predictable structure.

### Coming from GNOME or MATE?

If you're transitioning from GNOME or MATE, here are some key differences to understand:

- **Window Management**: In GNOME/MATE, windows can overlap freely and are typically manipulated with a mouse. In i3/I38, windows tile automatically and are primarily controlled with keyboard shortcuts.
- **Panels and Indicators**: Instead of persistent panels with menus and indicators, I38 uses keyboard shortcuts to access functionality.
- **Workspace Navigation**: While GNOME/MATE have workspaces that you can switch between, I38's workspaces are more central to the workflow and are accessed via dedicated keyboard shortcuts.
- **Application Launching**: Rather than using a start menu or activities overview, I38 provides keyboard shortcuts for launching applications.

I38 has been configured to make this transition easier by providing a tabbed layout (similar to browser tabs) and shortcuts that may feel somewhat familiar.


## Basic Concepts

### Workspaces

Workspaces act like virtual desktops, allowing you to organize applications. You have 10 workspaces available.

- Switch to workspace: `Control` + `F1` through `F10`
- Move window to workspace: `Control` + `Shift` + `F1` through `F10`

*GNOME/MATE comparison:* Similar to workspaces in GNOME/MATE, but with dedicated keyboard shortcuts rather than overview modes or workspace switchers.

### Window Management

Windows in I38 are arranged in a tabbed layout by default, which means windows take up the entire screen and you can switch between them like browser tabs.

- Switch between windows: `Alt` + `Tab` (next) or `Alt` + `Shift` + `Tab` (previous)
- Launch terminal: `MODKEY` + `Return`
- Close window: `MODKEY` + `F4`
- Toggle fullscreen: `MODKEY` + `BackSpace`
- List windows in current workspace: `RATPOISONKEY` then `'` (apostrophe)

*GNOME/MATE comparison:* Alt+Tab works similarly to GNOME/MATE, but window placement is automatic rather than manual.


## Modes in I38

### Default Mode

This is the standard mode for working with applications. Most commands start with your mod key (`MODKEY`).

### Ratpoison Mode

Ratpoison mode allows quick access to common actions using shorter key combinations. To enter Ratpoison mode, press `RATPOISONKEY`. After pressing this key, you can execute commands with single keystrokes.

Common Ratpoison mode commands:

| Key | Action |
|-----|--------|
| `c` | Launch a terminal |
| `e` | Open text editor (TEXTEDITOR) |
| `w` | Launch web browser (BROWSER) |
| `k` | Kill (close) the current window |
| `?` | Show I38 help |
| `Escape` or `Control` + `g` | Exit Ratpoison mode without taking action |
| `Shift` + `c` | Restart Cthulhu screen reader |
| `Shift` + `o` | Restart Orca screen reader |
| `Shift` + `t` | Toggle screen reader |
| `Control` + `;` | Reload I38 configuration |
| `Control` + `q` | Exit i3 (log out) |
| `!` | Open run dialog |
| `Alt` + `b` | Check battery status |
| `g` | Check game controller status |

*GNOME/MATE comparison:* This mode has no direct equivalent in GNOME/MATE. Think of it as a command palette or quick launcher activated by a single key.

### Bypass Mode

Bypass mode passes all keys directly to the application, which is useful for applications that need many keyboard shortcuts. To enter bypass mode, press `MODKEY` + `Shift` + `BackSpace`. Use the same key combination to exit bypass mode.

*GNOME/MATE comparison:* In GNOME/MATE, applications always receive keyboard input directly. Bypass mode simulates this behavior within i3.

## Panel Mode

Panel Mode provides quick access to information displays and utility panels. To enter Panel Mode, press `Alt` + `Control` + `Tab`. A distinctive sound will play when Panel Mode is active.

In Panel Mode, single keypresses launch different information panels:

| Key | Action |
|-----|--------|
| `w` | Display weather information |
| `Shift` + `w` | Open Magic Wormhole file transfer GUI |
| `s` | Show system information |
| `r` | Open reminder panel |
| `n` | Launch notes application |
| `b` | Open bluetooth. *requires blueman be installed at the time of your i3 config generation* |
| `Escape` or `Control` + `g` | Exit Panel Mode without taking action |

Just like Ratpoison Mode, Panel Mode automatically returns you to Default Mode after a selection is made or when you press Escape/Control+g to cancel.

*GNOME/MATE comparison:* Panel Mode replaces the persistent system tray and status indicators used in GNOME/MATE. Instead of having always-visible panels with clickable icons, I38 provides keyboard shortcuts to access this information on demand.

### System Information Panel

The system information panel (`s` key in Panel Mode) displays vital system statistics such as:
- CPU usage
- Memory usage
- Disk space
- Network status
- Battery level (if applicable)

### Weather Panel

The weather panel (`w` key in Panel Mode) provides current weather conditions and forecast information for your configured location.

### File Transfer with Magic Wormhole

The Magic Wormhole panel (`Shift` + `w` in Panel Mode) provides a graphical user interface to the Magic Wormhole command-line application, allowing you to securely share files with others. This offers a more accessible way to use Magic Wormhole's secure file transfer capabilities.

### Notes Application

The notes panel (`n` key in Panel Mode) provides a simple application for creating single-line notes with automatic expiration functionality:
- Create text notes quickly
- Set notes to automatically delete after a specified time period
- Lock important notes to prevent automatic deletion
- Temporary notes will expire after their set time limit

### Reminder Panel

The reminder panel (`r` key in Panel Mode) offers the same reminder functionality described in the Reminders and Notifications section, It was previously in ratpoison mode but has been moved to panel mode because it is a better fit.

*Note:* Because Panel Mode uses a custom implementation rather than a traditional system tray, applications that require a system tray to run may not work with I38.


## Accessibility Features

### Screen Reader

I38 is configured to work with your screen reader (SCREENREADER). The screen reader will provide spoken feedback about what's happening on screen so long as there is a window. If you don't have a window open and need to change something SCREENREADER related, press Control+Alt+d to bring up the desktop, then screen reader keys should work.

- Toggle screen reader: `RATPOISONKEY` then `Shift` + `t`
- Restart screen reader: `RATPOISONKEY` then `Shift` + `o` (for Orca) or `Shift` + `c` (for Cthulhu)
- Interrupt speech: `MODKEY` + `Shift` + `F5`

*GNOME/MATE comparison:* GNOME uses Orca by default with its own keyboard shortcuts. I38 integrates screen readers more deeply with the window manager.

### Braille Display Support

If you've enabled braille display support during setup, I38 will start XBrlAPI automatically to provide braille output from your screen reader.

### OCR (Optical Character Recognition)

If installed, you can use OCR to read text from images or inaccessible applications:

- `MODKEY` + `F5`: Perform OCR on the entire screen and speak the content
- In Ratpoison mode: `Print` or `MODKEY` + `r`: Perform OCR and save to clipboard

*GNOME/MATE comparison:* OCR features are typically not integrated into GNOME/MATE by default.

### Sound Effects

I38 provides audio feedback for many actions:

- Window open/close: Ascending/descending tones
- Mode changes: Distinctive sounds for each mode
- Workspace changes: Subtle audio cues
- Fullscreen toggle: Special sound effect

This audio feedback provides non-visual confirmation of actions and state changes.

*GNOME/MATE comparison:* GNOME/MATE typically have fewer sound effects for window management actions.

## Application Menu and Running Programs

Access applications in multiple ways:

- Applications menu: `MODKEY` + `F1`
- Run dialog (enter a command): `MODKEY` + `F2` or in Ratpoison mode, `!` (exclamation mark)
- Common applications have dedicated shortcuts in Ratpoison mode (see table above)

The applications menu is organized by categories similar to traditional desktop environments.

*GNOME/MATE comparison:* Instead of clicking on application icons or using a start menu, I38 provides keyboard shortcuts to access applications.


## Reminders and Notifications

I38 includes integration with the `remind` program for managing reminders:

- Access the reminder tool: `Alt+Control+Tab` then `r`
- Create various types of reminders (one-time, daily, weekly, monthly)
- Get notification alerts for your reminders

The reminder tool provides the following features:

- **One-time Reminders**: Set for a specific date and time
- **Daily Reminders**: Occur every day at the specified time
- **Weekly Reminders**: Occur on specific days of the week
- **Monthly Reminders**: Occur on a specific day each month or the last day of each month
- **Custom Reminders**: Create complex reminder patterns

*GNOME/MATE comparison:* Similar to calendar applications in GNOME/MATE but with a simplified interface optimized for keyboard navigation.


## Volume and Media Controls

### System Volume

- Increase volume: `MODKEY` + `XF86AudioRaiseVolume`
- Decrease volume: `MODKEY` + `XF86AudioLowerVolume`
- Mute/unmute: `MODKEY` + `XF86AudioMute`

### Media Player Controls

- Play/Pause: `XF86AudioPlay`
- Next track: `XF86AudioNext`
- Previous track: `XF86AudioPrev`
- Stop: `XF86AudioStop`
- Media info: `MODKEY` + `XF86AudioPlay`

In Ratpoison mode, these are also available with Alt+Shift combinations:

- Increase volume: `Alt` + `Shift` + `=`
- Decrease volume: `Alt` + `Shift` + `-`
- Previous track: `Alt` + `Shift` + `z`
- Pause: `Alt` + `Shift` + `c`
- Play: `Alt` + `Shift` + `x`
- Stop: `Alt` + `Shift` + `v`
- Next track: `Alt` + `Shift` + `b`
- Media info: `Alt` + `Shift` + `u`

*GNOME/MATE comparison:* Media controls are similar to those in GNOME/MATE, with the addition of audio feedback.


## File Management

I38 uses FILEBROWSER for file management. Launch it in Ratpoison mode with the `f` key.

*GNOME/MATE comparison:* Similar functionality to Nautilus (GNOME) or Caja (MATE), but launched via keyboard shortcut rather than from a desktop icon or menu.


## System Operations

- Reload I38 configuration: In Ratpoison mode, `Control` + `;` (semicolon)
- Exit i3 (log out): In Ratpoison mode, `Control` + `q`
- Check battery status: In Ratpoison mode, `Alt` + `b`
- Check game controller status: In Ratpoison mode, `g`
- Adjust screen brightness (if xrandr is available): In Ratpoison mode, `Alt` + `s`

*GNOME/MATE comparison:* These functions are typically available through system menus or indicators in GNOME/MATE.


## Keyboard Layouts

Switch between layouts: `Super` + `Space`

This is only available if you chose multiple keyboard layouts during setup.

*GNOME/MATE comparison:* Similar to keyboard layout switching in GNOME/MATE, but with a different default shortcut.


## Desktop and Window Decorations

Unlike GNOME or MATE, i3 uses minimal window decorations. Windows don't have title bars with minimize/maximize buttons. Instead, windows fill their available space automatically, and interactions are performed through keyboard shortcuts.

- Show desktop icons: `MODKEY` + `Control` + `d`

## Clipboard Management

I38 includes clipboard management features:

- Access clipboard history: `MODKEY` + `Control` + `c`

## Bookmark Management

- Access bookmarks: `MODKEY` + `Control` + `b`

*GNOME/MATE comparison:* Bookmarks are typically managed within applications in GNOME/MATE. I38 provides a system-wide bookmark manager.

## Tips for New Users

- **Use the window list**: When you're lost, use `RATPOISONKEY` then `'` to show all windows in the current workspace.
- **Bookmark important websites**: Use `MODKEY` + `Control` + `b` to access bookmarks.
- **Remember the help shortcut**: `MODKEY` + `Shift` + `F1` is your friend when you need guidance.
- **Let the sound effects guide you**: Pay attention to the audio cues to understand what's happening.
- **Take advantage of OCR**: If an application isn't accessible, try the OCR function.

### Transitioning from GNOME/MATE

- Start by learning the basic navigation shortcuts before exploring advanced features
- The tabbed layout should feel somewhat familiar if you're used to browser tabs
- Alt+Tab works similarly to GNOME/MATE for switching between windows
- Focus on keyboard commands rather than looking for visual elements like panels or docks

## Customization

You can customize I38 by editing the file `~/.config/i3/customizations`. This file will not be overwritten when you update I38.

Example customizations:

```
# Change background color
exec_always --no-startup-id xsetroot -solid "#2E3440"

# Add custom keybinding
bindsym $mod+F12 exec --no-startup-id pactl set-sink-volume @DEFAULT_SINK@ 100%
```

To reconfigure I38 completely, run the `i38.sh` script again.

*GNOME/MATE comparison:* Much more text-based configuration compared to the graphical settings dialogs in GNOME/MATE.

## Getting Help

If you need assistance with I38, you can:

- Press `MODKEY` + `Shift` + `F1` to view the help documentation
- Visit the Stormux website at [stormux.org](https://stormux.org)
- Join the Stormux irc at irc.stormux.org #stormux or #a11y
- Check the i3 documentation at [i3wm.org/docs/userguide.html](https://i3wm.org/docs/userguide.html)

---

*I38 - Making i3 accessible. A Stormux project. License: GPL v3*
