# I38

Accessibility setup script for the i3 window manager.

## i38.sh
Released under the terms of the GPL License Version 3: https://www.gnu.org/licenses/
This is a Stormux project: https://stormux.org


## Why the name?

An uppercase I looks like a 1, 3 from i3, and 8 because the song [We Are 138](https://www.youtube.com/watch?v=-n2Mkdw4q44) rocks!


## Requirements

- acpi: [optional] for battery status. It will still work even without this package, but uses it if it is installed. Required for the battery monitor with sound alerts.
- bc: For the information panel.
- clipster: clipboard manager
- dex: [optional] Alternative method for auto starting applications.
- i3-wm: The i3 window manager.
- jq: for getting the current workspace
- libcanberra: [optional] To play the desktop login sound.
- libnotify: For sending notifications
- lxsession: [optional] For GUI power options like shutdown
- magic-wormhole: [optional] for file sharing with magic-wormhole GUI
- notification-daemon: To handle notifications
- ocrdesktop: For getting contents of the current window with OCR.
- pamixer: for the mute-unmute script
- pandoc or markdown: To generate html files.
- pcmanfm: [optional] Graphical file manager.
- playerctl: music controls
- python-gobject: for applications menu.
- python-i3ipc: for sounds etc.
- remind: [optional] For reminder notifications, Requires notify-daemon and notify-send for automatic reminders.
- sox: for sounds.
- transfersh: [optional] for file sharing GUI
- udiskie: [optional] for automatically mounting removable storage
- x11bell: [optional] Bell support if you do not have a PC speaker. Available from https://github.com/jovanlanik/x11bell
- xbacklight: [optional] for screen brightness adjustment
- xclip: Clipboard support
- xfce4-notifyd: For sending notifications. Replaces notification-daemon (Sway users will need to install the customized variant at <https://github.com/icasdri/xfce4-notifyd-layer-shell>)
- xorg-setxkbmap: [optional] for multiple keyboard layouts
- yad: For screen reader accessible dialogs

I38 will try to detect your browser, file manager, and text editor and present you with a list of options to bind to their launch keys. It will also create bindings for pidgin and mumble if they are installed. To use the bindings, press your ratpoison mode key which is set when you run the i38.sh script. Next, press the binding for the application you want; w for web browser, e for text editor, f for file manager, m for mumble, etc. To learn all the bindings, find and read the mode ratpoison section of ~/.config/i3/config or use the help binding key, alt or super depending on your settings with Shift+F1.

The login sound uses the GTK sound theme. Configure this using GTK configuration files or gsettings. Replace "name" with the name of the theme you want to use.

Note that if you enable all sound events as shown below, you'll also hear GTK sounds when moving around menus, buttons, etc, if the sound theme has sounds for those events.

To configure the theme name with gsettings, do as follows:

    gsettings set org.gnome.desktop.sound theme-name name

If you'd like all sound types enabled:

    gsettings set org.gnome.desktop.sound input-feedback-sounds true

    gsettings set org.gnome.desktop.sound event-sounds true

To configure with a config file, edit or create ~/.config/gtk-3.0/settings.ini

    [Settings]
    gtk-enable-event-sounds=1
    gtk-enable-input-feedback-sounds=1
    gtk-sound-theme-name=name
    gtk-modules=canberra-gtk-module

You can apply the same configuration to GTK2 apps. Create or edit ~/.gtkrc-2.0

    gtk-enable-event-sounds=1
    gtk-enable-input-feedback-sounds=1
    gtk-sound-theme-name=name
    gtk-modules=canberra-gtk-module

## Usage:

- With no arguments, create the i3 configuration.
- -h: Help screen.
- -u: Copy over the latest version of scripts.
- -x: Generate ~/.xinitrc and ~/.xprofile.
- -X: Generate ~/.xprofile only.


## Ratpoison Mode

I38 is an adaptation of the old Strychnine project which was based on the Ratpoison window manager. Ratpoison is a screen-like window manager, and the important concept from that, which applies to I38, is adding keyboard shortcuts without conflicting application shortcuts. This is done with an "escape key".

When creating I38, I really wanted to port that functionality over, because it is very powerful and allows for lots and lots of shortcuts while minimizing collisions between shortcuts. So, for example, if you have chosen brave as your web browser, and selected alt+escape as your ratpoison mode key, you can quickly launch brave by pressing alt+escape followed by the letter w.


## Panel Mode

Very similar to ratpoison, accessed with Alt+Control+Tab. It contains items that would normally be found in a traditional desktop's panel. For example, it has a simple note app, system information, weather, bluetooth and power options, and remind.


## I38 Help

To get help for I38, you can press the top level keybinding alt+shift+F1. It is also available by pressing the ratpoison mode key followed by question mark. A limitation of yad, which is used to display the help text means that the cursor starts at the bottom of the text. Please press control+home to jump to the top. You can navigate with the arrow keys, and use control+f to find text within the document.

The help text is a modified version of the configuration file itself that is intended to be easier to read. I have tried to add in comments that should also serve to make things more clear.
