#!/usr/bin/env bash

# This file is part of I38.

# I38 is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation,
# either version 3 of the License, or (at your option) any later version.
                                                                                                                                                                          
# I38 is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
                                                                                                                                                                          
# You should have received a copy of the GNU General Public License along with I38. If not, see <https://www.gnu.org/licenses/>.


path="$(readlink -f $0)"
path="${path%/*/*}"
path="${path##*/}"
if [[ "$path" == "i3" ]]; then
    workSpace="$(i3-msg -t get_workspaces \
        | jq '.[] | select(.focused==true).name' \
        | cut -d"\"" -f2)"
else
    workSpace="$(swaymsg -t get_workspaces \
        | jq '.[] | select(.focused==true).name' \
        | cut -d"\"" -f2)"
fi
left=9
right=0
msg="Workspace ${workSpace}"
if [[ "${workSpace}" == "11" ]]; then
    play -qnV0 synth 1.5 pl A4 pl E5 pl C5 delay 0.0 0.1 0.2 remix - fade p 0 1.5 .5
    spd-say -P important -Cw "I38 panel"
    exit 0
fi
if ! [[ "${workSpace}" =~ ^[0-9]+$ ]]; then
    right=9
else
    if [[ ${workSpace} -eq 10 ]]; then
        left=0
        right=9
    elif [[ ${workSpace} -eq 5 ]]; then
        right=9
    elif [[ ${workSpace} -gt 5 ]]; then
        right=9
        ((left-=${workSpace}))
    else
        ((right+=${workSpace}))
    fi
fi
play -nqV0 synth pi fade 0 .25 .15 pad 0 1 reverb overdrive riaa norm -8 speed 1 remix v0.${left} v0.${right} &
spd-say -P important -Cw "${msg}"
