#!/usr/bin/env bash

# This file is part of I38.
                                                                                                                                                                          
# I38 is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation,
# either version 3 of the License, or (at your option) any later version.
                                                                                                                                                                          
# I38 is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
                                                                                                                                                                          
# You should have received a copy of the GNU General Public License along with I38. If not, see <https://www.gnu.org/licenses/>.
                                                                                                                                                                          
 
configPath="$(readlink -f $0)"
configPath="${configPath%/*/*}"

if [[ -f "${configPath}/config" ]]; then
    mod="$(grep 'set $mod ' "${configPath}/config" | cut -d ' ' -f3)"
    mod="${mod//Mod1/Alt}"
    mod="${mod//Mod4/Super}"
    mapfile helpText < <(sed -e '/set \($mod\|mod\)/d' \
        -e '/set $ws/d' \
        -e 's/bindsym/Key:/g' \
        -e 's/Mod1/Alt/g' \
        -e 's/, mode "default"//g' \
        -e 's/--no-startup-id //g' \
        -e 's/$ws\([0-9]\)/\1/g' \
        -e 's/play \(.*\)& //g' \
        -e "s/\$mod/$mod/g" "${configPath}/config")
else
    exit 1
fi
for i in "${!helpText[@]}" ; do
    helpText[$i]="${helpText[$i]//${configPath}\/scripts\//}"
    helpText[$i]="${helpText[$i]/.sh/}"
    helpText[$i]="${helpText[$i]/, exec announce*/$'\n'}"
    helpText[$i]="${helpText[$i]/, exec spd-say*/$'\n'}"
done
helpText+=("End of text. Please press Control+Home to jump to the beginning of this document.")
echo "${helpText[@]}" | yad --text-info --show-cursor --title "I38 help" --button "Close:0" --listen

exit 0
