#!/usr/bin/env bash

# This file is part of I38.
                                                                                                                                                                          
# I38 is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation,
# either version 3 of the License, or (at your option) any later version.
                                                                                                                                                                          
# I38 is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
                                                                                                                                                                          
# You should have received a copy of the GNU General Public License along with I38. If not, see <https://www.gnu.org/licenses/>.
                                                                                                                                                                          
 
# This script is a modified version of i3-keyboard-layout.
# Originally Copyright (c) 2018 Sergio Gil.
# https://github.com/porras/i3-keyboard-layout
# The original work was released under the MIT license.


set -e

get_kbdlayout() {
  layout=$(setxkbmap -query | grep -oP 'layout:\s*\K([\w,]+)')
  variant=$(setxkbmap -query | grep -oP 'variant:\s*\K(\w+)')
  echo "$layout" "$variant"
}

set_kbdlayout() {
  eval "array=($1)"
  setxkbmap "${array[@]}" &&
    spd-say -P important -Cw "${array[@]}"
}

cycle() {
  current_layout=$(get_kbdlayout | xargs)
  layouts=("$@" "$1") # add the first one at the end so that it cycles
  index=0
  while [ "${layouts[$index]}" != "$current_layout" ] && [ $index -lt "${#layouts[@]}" ]; do index=$[index +1]; done
  next_index=$[index +1]
  next_layout=${layouts[$next_index]}
  set_kbdlayout "$next_layout"
}


subcommand="$1"
shift || exit 1

case $subcommand in
  "get")
    echo -n $(get_kbdlayout)
    ;;
  "cycle")
    cycle "$@"
    ;;
esac

exit 0
