#!/bin/bash

# This file is part of I38.
                                                                                                                                                                          
# I38 is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation,
# either version 3 of the License, or (at your option) any later version.
                                                                                                                                                                          
# I38 is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
                                                                                                                                                                          
# You should have received a copy of the GNU General Public License along with I38. If not, see <https://www.gnu.org/licenses/>.
                                                                                                                                                                          
 
run_command() {
    playerctl -p '%any,chromium,firefox' $1
    sleep 0.25
}

show_info() {
    info="$( playerctl -p '%any,chromium,firefox' metadata -f '"{{title}}" by "{{artist}}" from "{{album}}"')"
    local count=1
    while [[ $count -le 10 ]] && [[ "$info" == "$oldInfo" ]]; do
        info="$(playerctl -p '%any,chromium,firefox' metadata -f '"{{title}}" by "{{artist}}" from "{{album}}"')"
        ((count++))
        sleep 0.25
    done
    notify-send "$info"
    exit 0
}


    oldInfo="$(playerctl -p '%any,chromium,firefox' metadata -f '"{{title}}" by "{{artist}}" from "{{album}}"')"
volume="0${2}"
volume=${volume: -2}
case "${1}" in
    "prev") run_command "previous";show_info;;
    "play") run_command "play";show_info;;
    "pause") run_command "play-pause";;
    "stop") run_command "stop";;
    "next") run_command "next";show_info;;
    "shuf") run_command "shuffle toggle";;
    "info") unset oldInfo;show_info;;
    "decvol") run_command "volume 0.${volume}-";;
    "incvol") run_command "volume 0.${volume}+";;
esac

exit 0
