#!/usr/bin/env bash

# This file is part of I38.
                                                                                                                                                                          
# I38 is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation,
# either version 3 of the License, or (at your option) any later version.
                                                                                                                                                                          
# I38 is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
                                                                                                                                                                          
# You should have received a copy of the GNU General Public License along with I38. If not, see <https://www.gnu.org/licenses/>.
                                                                                                                                                                          
 
write_history(){
oldHistory="$(grep -v "$txt" "${historyPath}/.history" | head -n 49)"
echo -e "$txt\n$oldHistory" | sed 's/^$//g' > "${historyPath}/.history"
}


historyPath="$(readlink -f $0)"
historyPath="${historyPath%/*}"
if ! [[ -d "$historyPath" ]]; then
    mkdir -p "$historyPath"
fi

if [[ -f "${historyPath}/.history" ]]; then
    txt="$(yad --entry --editable --title "I38" --text "Execute program or enter file" --button "Open:0" --separator "\n" --rest "${historyPath}/.history")"
else
    txt="$(yad --entry --title "I38" --text "Execute program or enter file" --button "Open:0")"
fi
if [[ -z "$txt" ]]; then
    exit 0
fi
if [[ "$txt" =~ ^ftp://|^http://|^https://|^www.* ]]; then
    xdg-open $txt
    write_history
    exit 0
fi
if [[ "$txt" =~ ^mailto://.* ]]; then
    xdg-email $txt
    write_history
    exit 0
fi
if [[ "$txt" =~ ^man://.* ]]; then
    eval "${txt/:\/\// }" | yad --text-info --show-cursor --button "Close:0" --title "I38" -
    write_history
    exit 0
fi
if command -v "$(echo "$txt" | cut -d " " -f1)" &> /dev/null ; then
    eval $txt&
else
    xdg-open $txt&
fi
write_history
exit 0
