#!/usr/bin/env bash

# This file is part of I38.
                                                                                                                                                                          
# I38 is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation,
# either version 3 of the License, or (at your option) any later version.
                                                                                                                                                                          
# I38 is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
                                                                                                                                                                          
# You should have received a copy of the GNU General Public License along with I38. If not, see <https://www.gnu.org/licenses/>.
                                                                                                                                                                          
 
# Not for multiple screens.
# Get the name of the screen.
screenName="$(xrandr --query | grep "connected" | cut -d ' ' -f1 | head -n 1)"

menuOptions=(
    "1.0" "Maximum Brightness"
    "0.75" "75 percent"
    "0.5" "50 percent"
    "0.25" "25 percent"
    "0" "Screen Curtain"
)

brightness="$(yad --list --title "I38" --text "Set Screen Brightness" --columns 2 --hide-column 1 --column "" --column "Select" "${menuOptions[@]}")"

if [[ ${#brightness} -lt 1 ]]; then
    exit 0
fi

xrandr --output ${screenName} --brightness ${brightness%%|*} &&
    spd-say -P important -Cw "Screen set to ${brightness#*|}."

exit 0
