#!/usr/bin/env bash

# This file is part of I38.
                                                                                                                                                                          
# I38 is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation,
# either version 3 of the License, or (at your option) any later version.
                                                                                                                                                                          
# I38 is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
                                                                                                                                                                          
# You should have received a copy of the GNU General Public License along with I38. If not, see <https://www.gnu.org/licenses/>.
                                                                                                                                                                          
 
path="$(readlink -f $0)"
path="${path%/*/*}"
path="${path##*/}"
if [[ "$path" == "i3" ]]; then
mapfile -t windowList < <(python3 -c '
import i3ipc

i3 = i3ipc.Connection()

for con in i3.get_tree():
    if con.window and con.parent.type != "dockarea":
        print(con.window)
        print(con.name)')
id="$(yad --title "I38" --list --separator "" --column "id" --column "Select Window" --hide-column 1 --print-column 1 "${windowList[@]}")"
if [[ -z "${id}" ]]; then
    exit 0
fi
    i3-msg \[id="${id}"\] focus
else
mapfile -t windowList < <(python3 -c '
import i3ipc
                                                                                                                                                                
i3 = i3ipc.Connection()
                                                                                                                                                                
for con in i3.get_tree():
    if con.window or con.type == "con":
        if con.name:
            print(con.window)
            print(con.name)')
                                                                                                                                                                
# Remove the first entry if it is "none"
if [[ "${windowList[0]}" == "none" ]]; then
    unset "windowList[0]"
fi
                                                                                                                                                                
id="$(yad --title "I38" --list --separator "" --column "id" --column "Select Window" --hide-column 1 --print-column 1 "${windowList[@]}")"
                                                                                                                                                                
if [[ -z "${id}" ]]; then
    exit 0
fi
swaymsg \[id="${id}"\] focus
fi
