#include <sys/socket.h>
#include <linux/ax25.h>

/*
 *	Library routine for callsign conversion.
 *
 */
 
int convert_call(char *name,struct sockaddr_ax25 *sax)
{
	int ct=0;
	int ssid=0;
	unsigned char *p=name;
	while(ct<6)
	{
		if(islower(*p))
			*p=toupper(*p);
		if(!isalnum(*p))
		{
			printf("Invalid symbol in callsign.\n");
			return -1;
		}
		
		sax->sax25_call.ax25_call[ct]=(*p<<1);
		p++;
		ct++;
		if(*p=='-' || *p==0)
			break;
	}
	while(ct<6)
	{
		sax->sax25_call.ax25_call[ct]=' '<<1;
		ct++;
	}
	if(*p==0)
		ssid=0;
	else
	{
		p++;
		if(sscanf(p,"%d",&ssid)!=1 || ssid<0 || ssid>15)
		{
			printf("SSID must follow '-' and be numeric in the range 0-15.\n");
			return -1;
		}
	}
	sax->sax25_call.ax25_call[6]=((ssid+'0')<<1)&0x1E;
	sax->sax25_family=AF_AX25;
	return 0;
}
