#include <stdio.h>
#include <linux/sockios.h>
#include <termios.h>
#include <fcntl.h>
#include <signal.h>

void setifcall(int fd, char *name)
{
	char call[7];
	int ct=0;
	int ssid=0;
	char *p=name;
	while(ct<6)
	{
		if(islower(*p))
			p=toupper(*p);
		call[ct]=(*p<<1);
		p++;
		ct++;
		if(*p=='-' || *p==0)
			break;
	}
	while(ct<6)
	{
		call[ct]=' '<<1;
		ct++;
	}
	if(*p==0)
		ssid=0;
	else
	{
		p++;
		if(sscanf(p,"%d",&ssid)!=1 || ssid<0 || ssid>15)
		{
			fprintf(stderr,"SSID must follow '-' and be numeric in the range 0-15.\n");
			exit(1);
		}
	}
	call[6]=((ssid+'0')<<1)&0x1E;
		
	if(ioctl(fd,SIOCSIFHWADDR,call)!=0)
	{
		close(fd);
		perror("SIOCSIFHWADDR");
		exit(1);
	}
}
	
	
		

void main(int argc,char *argv[])
{
	int fd;
	int disc=N_SLIP;
	char buf[64];
	int v=4;
	
	if(argc!=3)
	{
		fprintf(stderr,"%s <ttyinterface> <callsign>.\n");
		exit(1);
	}
	
	fd=open(argv[1],O_RDONLY|O_NDELAY);
	if(fd==-1)
	{
		perror(argv[1]);
		exit(1);
	}
	if(ioctl(fd,TIOCSETD,&disc)==-1)
	{
		perror("TIOCSETD");
		exit(1);
	}
	if(ioctl(fd,SIOCGIFNAME,buf)==-1)
	{
		perror("SIOCGIFNAME");
		exit(1);
	}
	
	setifcall(fd,argv[2]);
	
	/* Now set the encapsulation */
	if(ioctl(fd,SIOCSIFENCAP,&v)==-1)
	{
		perror("SIOCSIFENCAP");
		exit(1);
	}
		
	printf("Interface %s bound to tty %s with callsign %s\n",
		buf,argv[1],argv[2]);	
	signal(SIGHUP,SIG_IGN);
	while(1)
		sleep(10000);
}