#include <sys/types.h>
#include <sys/socket.h>
#include <linux/ax25.h>

#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <signal.h>

#include "config.h"


#define PMS_PATH	"/usr/local/ax25/pms/bin/pms"

void main(int argc, char *argv[])
{
	struct sockaddr_ax25 ax;
	char buf[1];
	int port=0;
	int s;
	
	if(config_load_ports()==-1)
	{
		fprintf(stderr,"%s: No ports configured.\n",argv[0]);
		exit(1);
	}
	if(argc>1)
	{
		if(strcmp(argv[1],"-p")==0)
		{
			if(argv[2]==NULL)
			{
				fprintf(stderr,"%s: -p option requires an argument.\n",argv[0]);
				exit(1);
			}
			if(sscanf(argv[2],"%d",&port)!=1)
			{
				fprintf(stderr,"%s: -p option requires a numeric argument.\n",argv[0]);
				exit(1);
			}
			port--;
			if(port<0||port>=config_num_ports())
			{
				fprintf(stderr,"%s: Unknown port.\n",argv[0]);
				exit(1);
			}
		}
	}
	if(argc!=1)
	{
		fprintf(stderr,"%s [-p port].\n",argv[0]);
		exit(1);
	}
	
	s=socket(AF_AX25,SOCK_SEQPACKET,PF_AX25);
	if(s==-1)
	{
		perror("socket");
		exit(1);
	}
	
	ax.sax25_family=AF_AX25;
	convert_call(config_get_addr(port),&ax);
		
	if(bind(s,(struct sockaddr *)&ax,sizeof(ax))==-1)
	{
		perror("bind");
		exit(1);
	}
	
	if(listen(s,5)==-1)
	{
		perror("connect");
		exit(1);
	}
	
	signal(SIGCLD,SIG_IGN);	/* No zombies */
	
	while(1)
	{
		int new=accept(s,NULL,0);
		if(new==-1)
			perror("accept");
		else
		{
			int pid=fork();
			if(pid==0)
			{	
				int win=config_get_window(port);
				setsockopt(new,SOL_AX25,AX25_WINDOW,&win,sizeof(win));
				dup2(new,0);
				dup2(new,1);
				dup2(new,2);
				if(new>2)
					close(new);
				if(s>2)
					close(s);
				execl(PMS_PATH,"pms",NULL);
				exit(1);
			}
			close(new);
		}
	}
	close(s);
}
