#include <sys/types.h>
#include <stdio.h>
#include <ctype.h>
#include <dirent.h>
#include <errno.h>
#include <fcntl.h>
#include <pwd.h>
#include <signal.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <sys/wait.h>
#include <termios.h>
#include <unistd.h>
#include <linux/ax25.h>

#include "config.h"

int debug_setting = 0;
int window_setting = 0;
int port_setting = 0;

void convert_cr_lf(char *buf,int len)
{
	while(len--)
	{
		if(*buf=='\r')
			*buf='\n';
		buf++;
	}
}

void convert_lf_cr(char *buf,int len)
{
	while(len--)
	{
		if(*buf=='\n')
			*buf='\r';
		buf++;
	}
}

static int connect_to(char *address)
{

  	int addrlen;
  	int fd;
  	struct sockaddr_ax25 addr;
  	char buf[256];
  	int one=debug_setting;

  	if ((fd = socket(AF_AX25, SOCK_SEQPACKET, PF_AX25)) < 0)
  	{
  		perror("socket");
		return(-1);
	}
	  
  	if(setsockopt(fd,SOL_SOCKET,SO_DEBUG,&one,sizeof(one))==-1)
  	{
  		perror("SO_DEBUG");
  		close(fd);
  		return -1;
  	}
  	
  	if(window_setting==0)
  		window_setting=config_get_window(port_setting);
  		
  	if(setsockopt(fd,SOL_AX25,AX25_WINDOW,&window_setting,sizeof(window_setting))==-1)
  		{
  			perror("AX25_WINDOW");
  		close(fd);
 		return -1;
	}

  	convert_call(config_get_addr(port_setting),&addr);
  	addrlen=sizeof(struct sockaddr_ax25);
    
  	if(bind(fd,(struct sockaddr *)&addr,addrlen)==-1)
  	{
  		perror("bind");
  		close(fd);
  		return -1;
  	}

  	if (convert_call(address,&addr)==-1)
  	{
  		close(fd);
  		return -1;
  	}
	
	printf("Trying...\r",address);
	fflush(stdout);
  
  	if (connect(fd, (struct sockaddr *)&addr, addrlen))
  	{
  		printf("\n");
		perror("connect");
		return(-1);
	}
  
  	printf("***Connected to %s\n",address);
  	return fd;
}

static volatile interrupted=0;

void cmd_intr()
{
	signal(SIGQUIT,cmd_intr);
	interrupted=1;
}

void cmd_call(char *tail)
{
	int fd=connect_to(tail);
	fd_set sock;
	fd_set sw;
	char buf[512];
	int bytes;
	int iscon=0;
	int logfile= -1;
	int uploadfile= -1;
 	int uplmode;
 	long uplsize;
 	long uplpos;
 	char uplbuf[128];	/* Upload buffer */
 	int upldp;
 	int upllen;

	if(fd==-1)
		return;

	interrupted=0;
	signal(SIGQUIT,cmd_intr);
	signal(SIGINT,SIG_IGN);
	signal(SIGTSTP,SIG_IGN);
	fcntl(fd,F_SETFL,O_NDELAY);
	fcntl(0,F_SETFL,O_NDELAY);
	while(1)
	{
		FD_ZERO(&sock);
		FD_SET(0,&sock);
		FD_SET(fd,&sock);
		FD_ZERO(&sw);
		if(uploadfile!= -1)
			FD_SET(fd,&sw);
		
		if(select(fd+1,&sock,&sw,&sock,NULL)==-1)
		{
			if(!interrupted && errno== EAGAIN)
				continue;
			if(!interrupted)
				perror("select");
			break;
		}
		while((bytes=read(fd,buf,511))>0)
		{
			convert_cr_lf(buf,bytes);
			if(logfile!= -1)
			{
				if(write(logfile,buf,bytes)!=bytes)
				{
					close(logfile);
					logfile= -1;
					printf("\nError while writing log. Log closed.\n");
				}
			}
			write(1,buf,bytes);
		}
		if(bytes==-1 && errno !=EWOULDBLOCK && errno!=EAGAIN)
		{
			if(errno!=ENOTCONN)
				perror("read");
			break;
		}
		bytes=read(0,buf,511);
		if(bytes>1 && *buf=='~')
		{
			buf[bytes]=0;
			switch(buf[1])
			{
				case '.':bytes = 0;
					 interrupted=1;
					 break;
				case '!':
				{
					char *c;
					if(buf[2] && buf[2]!='\n')
					{
						char *t;
						c=buf+2;
						t=strchr(c,'\n');
						if(t!=NULL)
							*t=0;
					}
					else
						c=getenv("SHELL");
					if(c==NULL)
						c="/bin/sh";
					fcntl(0,F_SETFL,0L);
					printf("\n[Spawning subshell]\n");
					system(c);
					printf("\n[Returned to connect]\n");
					fcntl(0,F_SETFL,O_NDELAY);
					continue;
				}
				case 'z':
				case 'Z':
				case 'Z'-64:
					fcntl(0,F_SETFL,0L);
					kill(getpid(),SIGSTOP);
					printf("\n[Resumed]\n");
					fcntl(0,F_SETFL,O_NDELAY);
					continue;
				case '?':
				case 'h':
				case 'H':
					printf("\nTilde escapes:\n.  close\n!  shell\nZ  suspend\ns Stop upload\no  Open log\nc  Close log\nu  Upload\n");
					continue;
				case 'S':
				case 's':
					if(uploadfile!= -1)
					{
						printf("\n[Upload file closed]\n");
						close(uploadfile);
						uploadfile= -1;
					}
					else
						printf("\n[No upload in progress]\n");
					continue;
				case 'u':
				case 'U':
				{
					char *t;
					if(uploadfile!=-1)
					{
						printf("\n[Already uploading]\n");
						continue;
					}
					t=strchr(buf,'\n');
					if(t!=NULL)
						*t=0;
					t=buf+2;
					while(*t && isspace(*t))
						t++;
					if(!*t)
					{
						printf("\n[Upload requires a filename - eg ~u hello.txt]\n");
						continue;
					}
					uploadfile=open(t,O_RDONLY,0);
					if(uploadfile==-1)
					{
						printf("\n[Unable to open upload file]\n");
						continue;
					}
					if(lseek(uploadfile,0L,2)!=-1)
						uplsize=lseek(uploadfile,0L,1);
					else
						uplsize=0;
					lseek(uploadfile,0L,0);
					uplpos=0;
					uplmode=0;
					upldp= -1;
					upllen= 0;
					if(uplsize!=-1)
						printf("\n[Uploading %ld bytes from %s]\n",uplsize,t);
					else
						printf("\n[Uploading from %s]\n",t);
					continue;
				}
				case 'o':
				{
					char *t=strchr(buf,'\n');
					if(t!=NULL)
						*t=0;
					if(logfile!= -1)
					{
						close(logfile);
						logfile= -1;
					}	
					t=buf+2;
					while(*t && isspace(*t))
						t++;
					if(!*t)
						t="logfile.txt";
					logfile=open(t,O_RDWR|O_APPEND|O_CREAT,0666);
					if(logfile==-1)
						printf("\n[Unable to open %s]\n",buf+2);
					continue;
				}
				case 'c':
					if(logfile!= -1)
					{
						close(logfile);
						logfile= -1;
					}
					else
						printf("\n[Log file not open]\n");
					continue;
				case '~':
					bytes--;
					memmove(buf,buf+1,strlen(buf));
					break;
				default:
					printf("\nUnknown '~' escape. Type ~h for a list.\n");
					continue;
			}
		}
					
		if(bytes==0 || (bytes==-1 && errno !=EWOULDBLOCK && errno!=EAGAIN))
		{
			if(!interrupted)
				perror("input");
			break;
		}
		if(bytes>0)
		{
			if(uploadfile!= -1)
			{
				printf("\n[Ignored. Type ~s to stop upload]\n");
				continue;
			}
			convert_lf_cr(buf,bytes);
			if(write(fd,buf,bytes)==-1)
			{
				perror("write");
				break;	
			}
		}
		if(uploadfile!=-1)
		{
			if(uplsize==0)
			{
				close(uploadfile);
				uploadfile= -1;
				printf("\n[Upload complete: 0 bytes\n");
				continue;
			}
			
			if(upldp==-1)
			{
				upllen=read(uploadfile,uplbuf,128);
				if(upllen==0)
				{
					close(uploadfile);
					uploadfile= -1;
					printf("\n[Upload complete: %ld bytes]\n",uplpos);
					continue;
				}
				if(upllen==-1)
				{
					close(uploadfile);
					uploadfile= -1;
					printf("\n[Error reading upload file: upload aborted at %ld bytes]\n",uplpos);
					continue;
				}
				convert_lf_cr(uplbuf,upllen);
				upldp=0;
			}
			bytes=write(fd,uplbuf+upldp,upllen-upldp);

			if((bytes == 0 || bytes==-1) && errno !=EWOULDBLOCK && errno!=EAGAIN)
			{
				printf("\n[Write error during upload. Connection lost]\n");
				perror("write");
				break;
			}
/*			if(uplpos/1024 != (uplpos+bytes)/1024)
			{*/
				printf("\r%d bytes sent    ",uplpos+bytes);
/*			}*/
			uplpos+=bytes;
			upldp+=bytes;
			if(upldp>=upllen)
				upldp= -1;
		}	
	}
	close(fd);
	if(logfile!= -1)
	{
		close(logfile);
		logfile= -1;
	}
	fcntl(0,F_SETFL,0);
	signal(SIGQUIT,SIG_IGN);
	signal(SIGINT,SIG_DFL);
	printf("*** Cleared\n");
}
	
	
void main(argc,argv)
int argc;
char *argv[];
{
	int p=1;
	int n;
	
	if(config_load_ports()==-1)
	{
		fprintf(stderr,"No AX.25 port data configured.\n");
		exit(1);
	}
	if(argv[p]&&strcmp(argv[p],"-p")==0)
	{
		p++;
		if(argv[p]==NULL || sscanf(argv[p],"%d",&n)==0)
		{
			fprintf(stderr,"%s: option '-p' requires numeric argument.\n",argv[0]);
			exit(1);
		}
		if(n<1||n>config_num_ports())
		{
			fprintf(stderr,"%s: port must be between 1 and %d.\n",argv[0],config_num_ports());
			exit(1);
		}
		p++;
		port_setting=n-1;
	}
	if(argv[p]&&strcmp(argv[p],"-w")==0)
	{
		p++;
		if(argv[p]==NULL || sscanf(argv[p],"%d",&n)==0)
		{
			fprintf(stderr,"%s: option '-w' requires numeric argument.\n",argv[0]);
			exit(1);
		}
		if(n<1||n>7)
		{
			fprintf(stderr,"%s: window must be between 1 and 7 frames.\n",argv[0]);
			exit(1);
		}
		p++;
		window_setting=n;
	}
		
	if(argv[p]&&strcmp(argv[p],"-d")==0)
	{
		debug_setting=1;
		p++;
	}
	if(argc!=p+1)
	{
		fprintf(stderr,"%s [-p port] [-w window] [-d] callsign\n",argv[0]);
		exit(1);
	}
	printf("GW4PTS AX.25 Connect v1.04\n");
	cmd_call(argv[p]);
}
