#include <sys/types.h>
#include <sys/socket.h>

#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>

int printcall(char *c)
{
	char *ep=c+6;
	int ct=0;
	while(ct<6)
	{
		if(((*c>>1)&127)==' ')
			break;
		putchar((*c>>1)&127);
		ct++;
		c++;
	}
	
	if((*ep&0x1E)!=0)
	{	
		putchar('-');
		printf("%d",(int)(((*ep)>>1)&0x0F));
	}
	
	if(*ep&1)
	{
		return 0;
	}
	return 1;
}

static char Printable(unsigned char c)
{
	if(c>31 && c<127)
		return(c);
	return('.');
}

void main()
{
	unsigned char buf[512];
	int size;
	int n=0;
	int s=socket(AF_INET,SOCK_PACKET,htons(2));
	if(s==-1)
	{
		perror("socket");
		exit(1);
	}
	
	while(1)
	{
		int hasdata=0;
		int hasaddr=0;
		int hassn=0,hasrn=0;
		int cmd=2;
		int v=0;
		size=recv(s,buf,512,0);
		if(size==-1)
		{
			perror("recv");
			exit(1);
		}
		n=0;
		if((buf[n]&0x0F)==0)
		{
			printf("KISS Data %-3d bytes:   From: ",size);
			v=printcall(buf+8);
			if(buf[8]&0x80)
				cmd=0;	/* cmd */
			if(buf[15]&0x80)
				cmd=1;	/* Response */
			printf("  To: ");
			printcall(buf+1);
			n+=15;
			while(v)
			{
				v=printcall(buf+n);
				n+=7;
			}
			printf("   ");
			switch(buf[n]&0xEF)
			{
				case 057:	printf("SABM");
				 	 	break;
				case 0143:	printf("UA");
						break;
				case 0103:	printf("DISC");
						break;
				case 017:	printf("DM");
						break;
				case 0207:	printf("FRMR");
						break;
				case 0003:	printf("UI");
						hasaddr=1;
						hasdata=1;
						break;
				default:
					if(buf[n]&1)
					{
						/* S frame */
						if(buf[n]&8)
							printf("REJ");
						else if(buf[n]&4)
							printf("RNR");
						else
							printf("RR");
						hasrn=1;
					}
					else
					{
						if((buf[n]&3)==3)
						{
							hasaddr=1;
							hasdata=1;
							printf("UI");
						}
						else
						{
							printf("I");
							hasaddr=1;
							hasdata=1;
							hasrn=1;
							hassn=1;
						}
					}
			}
			if(buf[n]&0x10)
			{
				switch(cmd)
				{
					case 0:printf("(P) ");break;
					case 1:printf("(F) ");break;
					case 2:printf("(P/F) ");break;
				}
			}
			else
				printf(" ");
			if(hasrn)
				printf("NR=%d ",(buf[n]>>5)&7);
			if(hassn)
				printf("NS=%d ",(buf[n])>>1&7);
			n++;
			if(hasaddr)
			{
				switch(buf[n++])
				{
					case 240: printf("PID=Text ");
						  break;
					case 207: printf("PID=NetROM ");
						  break;
					case 204: printf("PID=IP ");
						  hasdata=1;
						  break;
					case 205: printf("PID=ARP ");
						  hasdata=2;
						  break;
					default:  printf("PID=%d ",buf[n-1]);
						  hasdata=2;
						  break;
				}
			}
			
			printf("\n");			
					
		}
		else
			printf("KISS control %d\n",buf[n++]);
		
		if(hasdata==1)
		{	
			for(;n<size;n++)
			{
				printf("%c",Printable(buf[n]));
				if(v%64==63)
					putchar('\n');
				v++;
			}
			if(v%64!=0)
				putchar('\n');
		}
		else if(hasdata==2)
		{
			for(n=0;n<size;n++)
			{
				printf("%2X",buf[n]);
				if(v%32==31)
					putchar('\n');
				else
					putchar('.');
				v++;
			}
			if(v%64!=0)
				putchar('\n');
		}
		fflush(stdout);
		
	}
}