/*
 * QUOTA    An implementation of the diskquota system for the LINUX
 *          operating system. QUOTA is implemented using the BSD systemcall
 *          interface as the means of communication with the user level.
 *          Should work for all filesystems because of integration into the
 *          VFS layer of the operating system.
 *          This is based on the Melbourne quota system wich uses both user and
 *          group quota files.
 *
 *          Determines if a filesystem has quota enabled and how the quotafile
 *          is named.
 *
 * Version: $Id: hasquota.c,v 2.1 1993/11/06 11:16:39 mvw Exp mvw $
 *
 * Authors: Marco van Wieringen <v892273@si.hhs.nl> <mvw@mercury.mcs.nl.mugnet.org>
 *          Edvard Tuinder <v892231@si.hhs.nl> <ed@delirium.nl.mugnet.org>
 *
 *          This program is free software; you can redistribute it and/or
 *          modify it under the terms of the GNU General Public License
 *          as published by the Free Software Foundation; either version
 *          2 of the License, or (at your option) any later version.
 */
#include <sys/types.h>
#include <linux/quota.h>
#include <string.h>
#include "mntent.h"

#define CORRECT_FSTYPE(type) (!strcmp(type,MNTTYPE_EXT) || \
!strcmp(type,MNTTYPE_EXT2) || !strcmp(type,MNTTYPE_XIAFS) || \
!strcmp(type,MNTTYPE_MINIX))

char *qfname = QUOTAFILENAME;
char *qfextension[] = INITQFNAMES;

/*
 * Check to see if a particular quota is to be enabled.
 */
hasquota(struct mntent *mnt, int type, char **qfnamep)
{
   char *buf, *option, *pathname;

   if (!CORRECT_FSTYPE(mnt->mnt_type))
      return (0);

   if ((type == USRQUOTA) && (option = hasmntopt(mnt, MNTOPT_USRQUOTA)) != (char *)0 ||
       (type == GRPQUOTA) && (option = hasmntopt(mnt, MNTOPT_GRPQUOTA)) != (char *)0) {
      buf = (char *)malloc(512);
      if ((pathname = strchr(option, '=')) == (char *)0)
         (void) sprintf(buf, "%s/%s.%s", mnt->mnt_dir, qfname, qfextension[type]);
      else
         strcpy(buf, ++pathname);
      *qfnamep = buf;
      return (1);
   } else
      return (0);
}

