#include <stdio.h>
#include <signal.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <unistd.h>

#include <linux/isdn.h>

int                 isdn_device;

sig_handler()
{
    close(isdn_device);
    exit(1);
}

int
main(int argc, char *argv[])
{
    int                 ok, counter;
    FILE               *rd_fd;
    char               *buffer;
    int                 blocksize;
    int                 out_bytes = 0;
    struct stat         stat_buf;

    if (argc != 2) {
	fprintf(stderr, "usage: con number \n");
	exit - 1;
    }
    signal(SIGHUP, sig_handler);
    signal(SIGINT, sig_handler);
    signal(SIGQUIT, sig_handler);


    isdn_device = open("/dev/isdn1", O_RDWR);	/* ISDN-device */
    if (isdn_device == -1) {
	perror("/dev/isdn1");
	return -1;
    }
    ioctl(isdn_device, NUMBER, argv[1]);
    if (ioctl(isdn_device, D3_CONN_REQ, 0)) {
	perror("/dev/isdn1");
	return -1;
    }
    if (ioctl(isdn_device, B2_CONN_REQ, 0)) {
	perror("/dev/isdn1");
	return -1;
    }
    while (1)
	sleep(1);

    close(isdn_device);
    return 0;

}
