#include <stdio.h>
#include <signal.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <unistd.h>

#include <linux/isdn.h>
#include <linux/diehl.h>

int isdn_device;
static void print_indication(struct info_data *info);
struct info_data info;

sig_handler()
{
	close(isdn_device);
	ioctl(isdn_device,GET_PARAMETER,&info);
	print_indication(&info);
	exit(1);
}

int
main(int argc, char *argv[])
{
	int ok, counter;
	FILE *rd_fd;
	char *buffer;
	int	blocksize;
	int	out_bytes=0;
	struct stat stat_buf;

	if ( (argc < 2) || ( argc > 4 ))
	{
		fprintf(stderr,"usage: play number file [blocksize]\n");
		exit -1;
	}
	if (argc == 3)
		blocksize=1024;
	else
		blocksize=atoi(argv[3]);

	signal(SIGHUP,sig_handler);
	signal(SIGINT,sig_handler);
	signal(SIGQUIT,sig_handler); 

	buffer=(char *)malloc(blocksize);
	if (buffer == NULL)
	{
		perror("malloc");
		exit(-1);
	}


	isdn_device = open("/dev/isdn1", O_WRONLY);          /* ISDN-device */
	if (isdn_device == -1)
	{
		perror("/dev/isdn1");
		return 1;
	}

	ioctl(isdn_device,SET_OAD,3);
	ioctl(isdn_device,NUMBER,argv[1]);
	if(ioctl(isdn_device,D3_CONN_REQ,0))
	{
		ioctl(isdn_device,GET_PARAMETER,&info);
		print_indication(&info);
		perror("/dev/isdn1");
		exit(-1);
	}
	ioctl(isdn_device,GET_PARAMETER,&info);
	print_indication(&info);
	if(ioctl(isdn_device,B2_CONN_REQ,0))
	{
		perror("/dev/isdn1");
		exit(-1);
	}

	rd_fd = fopen(argv[2], "r");
	if (rd_fd == 0)
	{
		perror(argv[2]);
		return 1;
	}

	stat(argv[2],&stat_buf);

	while(out_bytes < stat_buf.st_size)
	{
		fread(buffer, sizeof(char), blocksize, rd_fd); 

		ok = write(isdn_device, buffer, blocksize);
		if (ok != blocksize)
		{	
			ioctl(isdn_device,GET_PARAMETER,&info);
			print_indication(&info);
			perror("write");
			exit (-1);
		}
		out_bytes+=ok;
	}


	fclose(rd_fd);
	ioctl(isdn_device,GET_PARAMETER,&info);
	print_indication(&info);
	close(isdn_device);
	return 0;

}
