#include <fcntl.h>
#include <unistd.h>

#include <linux/isdn.h>
#include <linux/diehl.h>

static void print_indication(struct info_data *info);
struct info_data info;
int isdn_device;

sig_handler()
{
	close(isdn_device);
	ioctl(isdn_device,GET_PARAMETER,&info);
	print_indication(&info);
	exit(1);
}

int
main(int argc, char *argv[])
{
	isdn_device = open("/dev/isdn1", O_RDWR);          /* ISDN-device */
	if (isdn_device == -1)
		{
		perror("/dev/isdn1");
		return 1;
		}

	ioctl(isdn_device,GET_PARAMETER,&info);
	print_indication(&info);
}

