#include <stdio.h>
#include <signal.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <unistd.h>

#include <linux/isdn.h>
#include <linux/diehl.h>

int isdn_device;
struct info_data info;

sig_handler()
{
	close(isdn_device);
	ioctl(isdn_device,GET_PARAMETER,&info);
	print_indication(&info);
	exit(1);
}

int
main(int argc, char *argv[])
{
	int ok, counter;
	FILE *rd_fd;
	char *buffer;
	int	blocksize;
	int	out_bytes=0;
	struct stat stat_buf;

	if ( (argc < 2) || ( argc > 4 ))
	{
		fprintf(stderr,"usage: $s number file [blocksize]\n",argv[0]);
		exit -1;
	}
	if (argc == 3)
		blocksize=1024;
	else
		blocksize=atoi(argv[3]);

	signal(SIGHUP,sig_handler);
	signal(SIGINT,sig_handler);
	signal(SIGQUIT,sig_handler);

	buffer=(char *)malloc(blocksize);
	if (buffer == NULL)
	{
		perror("malloc");
		exit(-1);
	}


	isdn_device = open("/dev/isdn1", O_RDONLY);          /* ISDN-device */
	if (isdn_device == -1)
		{
		perror("/dev/isdn1");
		return 1;
		}

	ioctl(isdn_device,NUMBER,argv[1]);
	ioctl(isdn_device,D3_CONN_REQ,0);
	ioctl(isdn_device,B2_CONN_REQ,0);

	rd_fd = fopen(argv[2], "w");
	if (rd_fd == 0)
	{
		perror(argv[2]);
		return 1;
	}

	do
	{
		ok = read(isdn_device, buffer, blocksize);
		
		if (ok != blocksize)
		{	
			perror("read");
			exit (-1);
		}
		fwrite(buffer, sizeof(char), blocksize, rd_fd); 
	}while (ok == blocksize);

	
	fclose(rd_fd);
	close(isdn_device);
	return 0;

}
