local offset = utf8.offset

do --- smoke
  assert(offset("A\u{20AC}3", 1) == 1)
  assert(offset("A\u{20AC}3", 2) == 2)
  assert(offset("A\u{20AC}3", 3) == 5)
  assert(offset("A\u{20AC}3", 4) == 6)
  assert(offset("A\u{20AC}3", 5) == nil)
  assert(offset("A\u{20AC}3", 6) == nil)
  assert(offset("A\u{20AC}3", -1) == 5)
  assert(offset("A\u{20AC}3", 1, 2) == 2)
  assert(offset("A\u{20AC}3", 2, 2) == 5)
  assert(offset("A\u{20AC}3", 3, 2) == 6)
  assert(offset("A\u{20AC}3", 4, 2) == nil)
  assert(offset("A\u{20AC}3", -1, 2) == 1)
  assert(offset("A\u{20AC}3", -2, 2) == nil)
  assert(offset("A\u{20AC}3", 1, 5) == 5)
  assert(offset("A\u{20AC}3", 2, 5) == 6)
  assert(offset("A\u{20AC}3", 3, 5) == nil)
  assert(offset("A\u{20AC}3", -1, 5) == 2)
  assert(offset("A\u{20AC}3", -2, 5) == 1)
  assert(offset("A\u{20AC}3", -3, 5) == nil)
  assert(offset("A\u{20AC}3", 1, 6) == 6)
  assert(offset("A\u{20AC}3", 2, 6) == nil)
  assert(offset("A\u{20AC}3", 1, -1) == 5)
  assert(offset("A\u{20AC}3", -1, -1) == 2)
  assert(offset("A\u{20AC}3", -2, -1) == 1)
  assert(offset("A\u{20AC}3", -3, -1) == nil)
  assert(offset("A\u{20AC}3", 1, -4) == 2)
  assert(offset("A\u{20AC}3", 2, -4) == 5)
  assert(offset("A\u{20AC}3", -1, -4) == 1)
  assert(offset("A\u{20AC}3", -2, -4) == nil)

  assert(offset("A\u{20AC}3", 0, 1) == 1)
  assert(offset("A\u{20AC}3", 0, 2) == 2)
  assert(offset("A\u{20AC}3", 0, 3) == 2)
  assert(offset("A\u{20AC}3", 0, 4) == 2)
  assert(offset("A\u{20AC}3", 0, 5) == 5)
  assert(offset("A\u{20AC}3", 0, 6) == 6)
end
