"use strict";/*!
 * HND JavaScript search engine
 * Copyright (C) IBE Software - All rights reserved.
 * Can only be used in documentation generated by HelpNDoc: http://www.helpndoc.com
 */
var Score;!function(r){r[r.TopicNumber=0]="TopicNumber",r[r.TopicScore=1]="TopicScore"}(Score||(Score={}));var HndJsSeWordList=function(){function r(){this.words=[]}return r.prototype.AddWord=function(r){this.words.push(r.toLowerCase())},r.prototype.Clear=function(){this.words=[]},r.prototype.Count=function(){return this.words.length},r.prototype.FindExact=function(r){return r=r.toLowerCase(),this.words.indexOf(r)},r.prototype.FindPartial=function(r){r=r.toLowerCase();for(var o=0;o<this.words.length;o++)if(-1!==r.indexOf(this.words[o]))return o;return-1},r}(),HndJsSeResultScore=function(){function r(){this.scores=[]}return r.prototype.FindTopicIndex=function(r){for(var o=0;o<this.scores.length;o++){if(this.scores[o][Score.TopicNumber]===r)return o}return-1},r.prototype.AddTopics=function(r){var o=this;if(!r||!r.forEach)return void console.error("Invalid AddTopics call");r.forEach(function(r){if(!r||!Array.isArray(r)||2!==r.length)return void console.error("Invalid data in AddTopics");var e=r[Score.TopicNumber],t=r[Score.TopicScore];if("number"!=typeof e||e<0||"number"!=typeof t||t<0)return void console.error("Invalid topic data in AddTopics");var i=o.FindTopicIndex(e);i>-1?o.scores[i][Score.TopicScore]=o.scores[i][Score.TopicScore]+t:o.scores.push([e,t])})},r.prototype.Clear=function(){this.scores=[]},r.prototype.ExcludeTopics=function(r){var o=this;if(!r||!r.forEach)return void console.error("Invalid ExcludeTopics call");r.forEach(function(r){if(!r||!Array.isArray(r)||2!==r.length)return void console.error("Invalid data in ExcludeTopics");var e=r[Score.TopicNumber];if("number"!=typeof e||e<0)return void console.error("Invalid topic data in ExcludeTopics");var t=o.FindTopicIndex(e);t>-1&&o.scores.splice(t,1)})},r.prototype.SortByScore=function(){this.scores.sort(function(r,o){return r[Score.TopicScore]>o[Score.TopicScore]?-1:r[Score.TopicScore]<o[Score.TopicScore]?1:0})},r}(),HndJsSe=function(){function r(){this.inputWordsExcluded=new HndJsSeWordList,this.inputWordsIncluded=new HndJsSeWordList,this.inputWordsMandatory=new HndJsSeWordList,this.resultScoreIncluded=new HndJsSeResultScore,this.resultScoreMandatory=new HndJsSeResultScore,this.resultScoreExcluded=new HndJsSeResultScore}return r.prototype.Reset=function(){this.input="",this.inputWordsExcluded.Clear(),this.inputWordsIncluded.Clear(),this.inputWordsMandatory.Clear(),this.resultScoreIncluded.Clear(),this.resultScoreMandatory.Clear(),this.resultScoreExcluded.Clear()},r.prototype.ParseInput=function(r){this.Reset(),this.input=r.trim();for(var o,e=/[-+]?"[^"]+"|[-+]?[^"\s]+/g;o=e.exec(this.input);)if(o[0]){var t=o[0].trim().toLowerCase();if(""!=t){var i="";for("-"!==t[0]&&"+"!==t[0]||(i=t[0],t=t.substr(1));t.length>0&&'"'===t[0];)t=t.substr(1);for(;t.length>0&&'"'===t[t.length-1];)t=t.substr(0,t.length-1);switch(i){case"-":this.inputWordsExcluded.AddWord(t);break;case"+":this.inputWordsIncluded.AddWord(t);break;default:this.inputWordsMandatory.AddWord(t)}}}},r.prototype.PerformSearch=function(r){var o=this;if(this.resultScoreIncluded=new HndJsSeResultScore,this.resultScoreMandatory=new HndJsSeResultScore,this.resultScoreExcluded=new HndJsSeResultScore,!r||!r.length)return console.error("Invalid word list data"),[];var e;r.forEach(function(r){if("string"==typeof r)e=r.trim().toLowerCase();else{if(!Array.isArray(r))return void console.error("Invalid element in word list data:",r);if(""==e)return void console.warn("Empty word should not be included in list");-1!==o.inputWordsIncluded.FindPartial(e)&&o.resultScoreIncluded.AddTopics(r),-1!==o.inputWordsMandatory.FindPartial(e)&&o.resultScoreMandatory.AddTopics(r),-1!==o.inputWordsExcluded.FindPartial(e)&&o.resultScoreExcluded.AddTopics(r)}});var t=this.resultScoreIncluded;return t.AddTopics(this.resultScoreMandatory.scores),t.ExcludeTopics(this.resultScoreExcluded.scores),t.SortByScore(),t.scores},r}();