﻿// --------------------------------------------------------------------------------------------------------------------
// <copyright file="IHbFunctions.cs" company="HandBrake Project (http://handbrake.fr)">
//   This file is part of the HandBrake source code - It may be used under the terms of the GNU General Public License.
// </copyright>
// <summary>
//   An interface to access the native libhb functions without using static methods.
// </summary>
// <auto-generated> Disable Stylecop Warnings for this file  </auto-generated>
// --------------------------------------------------------------------------------------------------------------------

namespace HandBrake.Interop.Interop.HbLib.Wrappers.Interfaces
{
    using System;
    using System.Runtime.InteropServices;

    public interface IHbFunctions
    {
        void hb_register_logger(LoggingCallback callback);

        void hb_register_error_handler(LoggingCallback callback);

        int hb_global_init();

        int hb_global_init_no_hardware();

        IntPtr hb_init(int verbose, int update_check);

        IntPtr hb_init_dl(int verbose, int update_check);

        IntPtr hb_get_version(IntPtr hbHandle);

        int hb_get_build(IntPtr hbHandle);

        IntPtr hb_dvd_name(IntPtr path);

        void hb_dvd_set_dvdnav(int enable);

        void hb_scan(IntPtr hbHandle, IntPtr path, int title_index, int preview_count, int store_previews, ulong min_duration);

        void hb_scan_stop(IntPtr hbHandle);

        IntPtr hb_get_titles(IntPtr hbHandle);

        void hb_set_anamorphic_size2(ref hb_geometry_s sourceGeometry, ref hb_geometry_settings_s uiGeometry, ref hb_geometry_s result);

        int hb_count(IntPtr hbHandle);

        IntPtr hb_job(IntPtr hbHandle, int jobIndex);

        void hb_rem(IntPtr hbHandle, IntPtr job);

        void hb_start(IntPtr hbHandle);

        void hb_pause(IntPtr hbHandle);

        void hb_resume(IntPtr hbHandle);

        void hb_stop(IntPtr hbHandle);

        void hb_close(IntPtr hbHandle);

        void hb_global_close();

        IntPtr hb_list_init();

        int hb_list_count(IntPtr listPtr);

        void hb_list_add(IntPtr listPtr, IntPtr item);

        void hb_list_insert(IntPtr listPtr, int pos, IntPtr item);

        void hb_list_rem(IntPtr listPtr, IntPtr item);

        IntPtr hb_list_item(IntPtr listPtr, int itemIndex);

        void hb_list_close(IntPtr listPtrPtr);

        int hb_subtitle_can_force(int source);

        int hb_subtitle_can_burn(int source);

        int hb_subtitle_can_pass(int source, int mux);

        int hb_video_framerate_get_from_name(IntPtr name);

        IntPtr hb_video_framerate_get_next(IntPtr last);

        IntPtr hb_audio_samplerate_get_next(IntPtr last);

        int hb_audio_samplerate_find_closest(int samplerate, uint codec);

        int hb_audio_bitrate_get_best(uint codec, int bitrate, int samplerate, int mixdown);

        int hb_audio_bitrate_get_default(uint codec, int samplerate, int mixdown);

        int hb_audio_bitrate_get_limits(uint codec, int samplerate, int mixdown, ref int low, ref int high);

        IntPtr hb_audio_bitrate_get_next(IntPtr last);

        void hb_video_quality_get_limits(uint codec, ref float low, ref float high, ref float granularity, ref int direction);

        IntPtr hb_video_quality_get_name(uint codec);

        void hb_audio_quality_get_limits(uint codec, ref float low, ref float high, ref float granularity, ref int direction);

        float hb_audio_quality_get_default(uint codec);

        void hb_audio_compression_get_limits(uint codec, ref float low, ref float high, ref float granularity, ref int direction);

        float hb_audio_compression_get_default(uint codec);

        int hb_audio_can_apply_drc2(IntPtr handle, int title_index, int audio_index, int encoder);

        int hb_mixdown_is_supported(int mixdown, uint codec, ulong layout);

        int hb_mixdown_has_codec_support(int mixdown, uint codec);

        int hb_mixdown_has_remix_support(int mixdown, ulong layout);

        int hb_mixdown_get_best(uint codec, ulong layout, int mixdown);

        int hb_mixdown_get_default(uint codec, ulong layout);

        IntPtr hb_mixdown_get_next(IntPtr last);

        IntPtr hb_video_encoder_get_next(IntPtr last);

        IntPtr hb_audio_encoder_get_next(IntPtr last);

        IntPtr hb_container_get_next(IntPtr last);

        IntPtr hb_video_encoder_get_presets(int encoder);

        IntPtr hb_video_encoder_get_tunes(int encoder);

        IntPtr hb_video_encoder_get_profiles(int encoder);

        IntPtr hb_video_encoder_get_levels(int encoder);

        IntPtr lang_get_next(IntPtr last);

        IntPtr lang_for_code2([In] [MarshalAs(UnmanagedType.LPStr)] string code2);

        void hb_job_close(IntPtr job);

        IntPtr hb_filter_get_keys(int filter_id);

        IntPtr hb_x264_encopt_name(IntPtr name);

        int hb_check_h264_level(
            [In] [MarshalAs(UnmanagedType.LPStr)] string level,
            int width,
            int height,
            int fps_num,
            int fps_den,
            int interlaced,
            int fake_interlaced);

        IntPtr hb_x264_param_unparse(
            int bit_depth,
            [In] [MarshalAs(UnmanagedType.LPStr)] string x264_preset,
            [In] [MarshalAs(UnmanagedType.LPStr)] string x264_tune,
            [In] [MarshalAs(UnmanagedType.LPStr)] string x264_encopts,
            [In] [MarshalAs(UnmanagedType.LPStr)] string x264_profile,
            [In] [MarshalAs(UnmanagedType.LPStr)] string h264_level,
            int width,
            int height);

        int hb_qsv_available();

        int hb_vce_h264_available();

        int hb_vce_h265_available();

        int hb_nvenc_h264_available();

        int hb_nvenc_h265_available();

        IntPtr hb_get_preview2(IntPtr hbHandle, int title_idx, int preview_idx, ref hb_geometry_settings_s geo, int deinterlace);

        IntPtr hb_image_close(IntPtr image);

        IntPtr hb_get_title_set_json(IntPtr hbHandle);

        IntPtr hb_job_init_json(IntPtr hbHandle, int title_index);

        IntPtr hb_json_to_job(IntPtr hbHandle, IntPtr json_job);

        int hb_add_json(IntPtr hbHandle, IntPtr json_job);

        IntPtr hb_set_anamorphic_size_json(IntPtr json_param);

        IntPtr hb_get_state_json(IntPtr hbHandle);

        IntPtr hb_get_preview_params_json(int title_idx, int preview_idx, int deinterlace, ref hb_geometry_settings_s settings);

        void hb_presets_builtin_init();

        IntPtr hb_presets_builtin_get_json();

        IntPtr hb_presets_read_file_json(IntPtr filename);

        IntPtr hb_presets_current_version(IntPtr major, IntPtr minor, IntPtr micro);

        IntPtr hb_generate_filter_settings_json(
            int filter_id,
            [In] [MarshalAs(UnmanagedType.LPStr)] string preset,
            [In] [MarshalAs(UnmanagedType.LPStr)] string tune,
            [In] [MarshalAs(UnmanagedType.LPStr)] string custom);

        IntPtr hb_filter_get_presets_json(int filter_id);

        IntPtr hb_filter_get_tunes_json(int filter_id);
    }
}
