/**************************************************************************
* Otter Browser: Web browser controlled by the user, not vice-versa.
* Copyright (C) 2013 - 2018 Michal Dutkiewicz aka Emdek <michal@emdek.pl>
* Copyright (C) 2014 - 2016 Jan Bajer aka bajasoft <jbajer@gmail.com>
* Copyright (C) 2014 Piotr Wójcik <chocimier@tlen.pl>
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program. If not, see <http://www.gnu.org/licenses/>.
*
**************************************************************************/

#ifndef OTTER_PREFERENCESGENERALPAGEWIDGET_H
#define OTTER_PREFERENCESGENERALPAGEWIDGET_H

#include <QtWidgets/QWidget>

namespace Otter
{

namespace Ui
{
	class PreferencesGeneralPageWidget;
}

class PreferencesGeneralPageWidget final : public QWidget
{
	Q_OBJECT

public:
	explicit PreferencesGeneralPageWidget(QWidget *parent = nullptr);
	~PreferencesGeneralPageWidget();

public slots:
	void save();

protected:
	void changeEvent(QEvent *event) override;

protected slots:
	void useCurrentAsHomePage();
	void useBookmarkAsHomePage(QAction *action);
	void restoreHomePage();
	void setupAcceptLanguage();

private:
	QString m_acceptLanguage;
	Ui::PreferencesGeneralPageWidget *m_ui;

signals:
	void settingsModified();
};

}

#endif
