/* 
  SZARP: SCADA software 
  

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
*/
/* $Id$ */

/*
 * SZARP 2.0
 * biblioteka MyInc
 * ipctools.h
 */


/*
 * Modified by Codematic 15.01.1998
 */

#ifndef _IPCTOOLS_H_
#define _IPCTOOLS_H_

extern "C" {
#include <sys/types.h> /* For ushort - Codematic */
}

#include "ipcdefines.h"


extern short *Probe;		/* wsplna pami prbki */	

extern short *Minute;		/* wsplna pami minuta */

extern short *Min10;		/* wsplna pami 10minut */

extern short *Hour;		/* wsplna pami godzina */

extern short *Day;		/* wsplna pami doba */

extern unsigned char *Alert;    /* wsplna pami alarmy przekrocze */

struct phPTTEntry		/* opis pojedynczego parametru */
 {
  ushort addr;			/* adres w dzielonych tablicach */
  unsigned char dot;		/* pozycja kropki */
  char sym[SHORT_NAME_LEN];	/* nazwa skrtowa */
  char full[FULL_NAME_LEN];	/* pena nazwa */
  char alt[ALT_NAME_LEN];	/* nazwa alternatywna dla Przegladajacego*/
 };

typedef struct phPTTEntry tPTTEntry, *pPTTEntry;

struct phPTTInfo
 {
  ushort rev;			/* revision code */
  ushort len;			/* ilo wszystkich parametrw */
  ushort blen;			/* ilo parametrw dla bazy */
  short  dlen;			/* ilo parametrw definiowanych (0 to brak) */ 
  tPTTEntry tab[2];		/* faktyczna dugo len elementw */	
 };

typedef struct phPTTInfo tPTTInfo;
typedef struct phPTTInfo * pPTTInfo;

extern pPTTInfo PTT;		/* wsplna pami PTT */

extern ushort VTlen, ExtraPars;

// from (void) to (int) - moified by Vooyeck

/* inicjalizacja segmentw dzielonych parametrw */
extern int ipcInitialize();

/** wola przez podana liczbe sekund @see ipcInitialize ( co jedna sekunde )
 * wychodzi gdy zostanie przekorczony czas lub funkcja ipcInitialize zworci
 * cos innego niz -1
 * @param attempts ilosc prob
 * @return warosc ostatniego wywolania @see ipcInitialize
 */
int ipcInitializewithSleep(int attempts);

#if 0
int ipcPTTGet(char *programname);	/* inicjalizacja segmentu dzielonego PTT */
#endif
//int ipcPTTGetLocal(char *programname);	/* inicjalizacja prywatnej kopii PTT */
int ipcRdGetInto(unsigned char shmdes);	/* wejcie dla czytaczy */
int ipcRdGetOut(unsigned char shmdes);		/* wyjcie dla czytaczy */
int ipcWrGetInto(unsigned char shmdes); 	/* wejcie pisarzy */
int ipcWrGetOut(unsigned char shmdes);		/* wyjcie pisarzy */

#endif

