<?xml version="1.0" encoding="iso-8859-2" standalone="yes"?>

<!--
	Stylesheet for SZARP XML reports generated by Apache mod-xslt2.
	
	Pawe Paucha <pawel@praterm.com.pl>
	$Id: raport_xml.xsl 2867 2005-11-27 00:04:15Z pawel $
 -->

<xsl:stylesheet version="1.0" 
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:isl="http://www.praterm.com.pl/ISL/params"
  xmlns:ipk="http://www.praterm.com.pl/SZARP/ipk"
  xmlns:xlink="http://www.w3.org/1999/xlink"
  xmlns:list="http://www.praterm.com.pl/SZARP/list"
  xmlns:rap="http://www.praterm.com.pl/SZARP/reports"
  extension-element-prefixes="mx2"
  xmlns:mx2="http://www.mod-xslt2.com/ns/1.0"
  >

  <xsl:output method="xml" indent="yes" media-type="text/xml" encoding="UTF-8"/>
  <!-- report title, read from HTTP request -->
  <xsl:variable name="title">
  	<mx2:value-of select="$GET[title]"/>
  </xsl:variable>
  <!-- uri to paramd server, read from config file -->
  <xsl:variable name="uri">
  	<mx2:value-of select="$uri"/>
  </xsl:variable>

  <xsl:template match="ipk:params">

    <xsl:element name="list:parameters">

      <xsl:attribute name="source">
        <xsl:value-of select="@title"/>
      </xsl:attribute>
      
      <xsl:attribute name="rap:title">
        <xsl:value-of select="$title"/>
      </xsl:attribute>

      <xsl:for-each select="//ipk:param[ipk:raport[@title=$title]]">

        <xsl:element name="list:param">

          <xsl:attribute name="name">
            <xsl:value-of select="@name"/>
          </xsl:attribute>
	  <xsl:attribute name="rap:short_name">
	    <xsl:value-of select="@short_name"/>
	  </xsl:attribute>

	  <xsl:if test="./ipk:raport[@title=$title]/@description">
	    <xsl:attribute name="rap:description">
	      <xsl:value-of select="./ipk:raport[@title=$title]/@description"/>
	    </xsl:attribute>
	  </xsl:if>

	  <xsl:if test="./ipk:raport[@title=$title]/@order">
	    <xsl:attribute name="rap:order">
	      <xsl:value-of select="./ipk:raport[@title=$title]/@order"/>
	    </xsl:attribute>
	  </xsl:if>

          <xsl:variable name="val">
	    <!-- transliterate for easier handling of non-ASCII characters in
	    report names -->
            <xsl:copy-of select="document(concat($uri,
            translate(@name, '󶼿ʣӦ/ :',
	    'acelnoszzACELNOSZZ__/'),'@value'))/isl:params/isl:attribute/text()"/> 
          </xsl:variable>

	  <xsl:choose>
	    <xsl:when test="string-length($val)=0">
	      <xsl:attribute name="rap:value">
	        <xsl:value-of select="'Brak cznoci'"/>
	      </xsl:attribute>
	    </xsl:when>
	    <xsl:otherwise>
	      <xsl:attribute name="rap:value">
	        <xsl:value-of select="$val"/>
	      </xsl:attribute>
	    </xsl:otherwise>
	  </xsl:choose>

	  <xsl:attribute name="rap:unit">
	    <xsl:value-of select="@unit"/>
	  </xsl:attribute>

        </xsl:element> <!-- name="param" -->

      </xsl:for-each> <!-- select="//ipk:param[ipk:raport[@title=$title]]" -->

    </xsl:element> <!-- name="parameters" -->

  </xsl:template> <!-- match="ipk:params" -->

</xsl:stylesheet>

