/* 
 SZARP: SCADA software 
 

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 */
/*
 * SZAU - Szarp Automatic Updater
 * SZARP

 * Sawomir Chyek schylek@praterm.com.pl
 *
 * $Id$
 */

#ifndef SZAUTASKBARITEM_H_
#define SZAUTASKBARITEM_H_

#ifndef WX_PRECOMP
#include <wx/wx.h>
#include <wx/wxprec.h>
#include <wx/progdlg.h>
#include <wx/cmdline.h>
#include <wx/taskbar.h>
#include <wx/tokenzr.h>
#include <wx/timer.h>
#else
#include <wx/wx.h>
#endif

#include "balloontaskbaritem.h"
#include "updater.h"

#include <vector>

/**class displaying icon on a taskbar
 * and context menu upon mouse click*/
#if defined(__WXMSW__) && defined(__HAS_BALLOON__)
class SzauTaskBarItem : public BalloonTaskBar {
#else
class SzauTaskBarItem : public wxTaskBarIcon {
#endif
DECLARE_EVENT_TABLE()
	;

	/**Creates context menu*/
	virtual wxMenu* CreatePopupMenu();
	/**Handles event generated by "Close application" menu item*/
	void OnCloseMenuEvent(wxCommandEvent &event);
	/**Handles event generated by "About" menu item*/
	void OnAbout(wxCommandEvent &event);
	void OnLeftMouseDown(wxTaskBarIconEvent &event);
	void OnInstall(wxCommandEvent &event);

	wxTimer* m_timer;

	/**timer event handler.*/
	void OnTimer(wxTimerEvent& event);

	std::vector<wxIcon> m_frames;
	wxIcon m_wait_icon;
	wxIcon m_new_icon;
	wxIcon m_error_icon;
	int m_current_frame_no;
	Updater * m_updater;
	UpdaterStatus m_prev_status;
	
	wxMenu * m_menu;

public:
	SzauTaskBarItem(Updater* updater, UpdaterStatus status);
};

#endif /*SZAUTASKBARITEM_H_*/
