#!/bin/sh
config() {
  NEW="$1"
  OLD="`dirname $NEW`/`basename $NEW .new`"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "`cat $OLD | md5sum`" = "`cat $NEW | md5sum`" ]; then # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}
config etc/rc.d/rc.httpd.new
# This won't be needed.  The point here is to preserve the permissions of the existing
# file, if there is one.  I don't see major new development happening in rc.httpd...  ;-)
rm -f etc/rc.d/rc.httpd.new

# Now copy the Apache config files into place if there are not existing copies:
for cfgfile in access.conf httpd.conf magic mime.types srm.conf ; do
   if [ ! -f etc/apache/${cfgfile} ]; then
      cp -a etc/apache/${cfgfile}.default etc/apache/${cfgfile}
   fi
done
( cd usr/lib ; rm -rf libmm.so.13 )
( cd usr/lib ; ln -sf libmm.so.13.0.20 libmm.so.13 )
( cd usr/lib ; rm -rf libmm.so )
( cd usr/lib ; ln -sf libmm.so.13.0.20 libmm.so )
( cd usr/sbin ; rm -rf apachectl )
( cd usr/sbin ; ln -sf apachectl-standard apachectl )
