/*
  Copyright 1999-2005 ImageMagick Studio LLC, a non-profit organization
  dedicated to making software imaging solutions freely available.
  
  You may not use this file except in compliance with the License.
  obtain a copy of the License at
  
    http://www.imagemagick.org/script/license.php
  
  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.

  ImageMagick token methods.
*/
#ifndef _MAGICK_TOKEN_H
#define _MAGICK_TOKEN_H

#if defined(__cplusplus) || defined(c_plusplus)
extern "C" {
#endif

/*
  Typedef declarations.
*/
typedef struct _TokenInfo
{
  int
    state;

  MagickStatusType
    flag;

  long
    offset;

  char
    quote;
} TokenInfo;

extern MagickExport int
  Tokenizer(TokenInfo *,unsigned,char *,size_t,char *,char *,char *,char *,
    char,char *,int *,char *);

extern MagickExport MagickBooleanType
  GlobExpression(const char *,const char *),
  IsGlob(const char *);

extern MagickExport void
  GetMagickToken(const char *,char **,char *);

#if defined(__cplusplus) || defined(c_plusplus)
}
#endif

#endif
