/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM nsIShellService.idl
 */

#ifndef __gen_nsIShellService_h__
#define __gen_nsIShellService_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class nsIDOMElement; /* forward declaration */


/* starting interface:    nsIShellService */
#define NS_ISHELLSERVICE_IID_STR "7d8a7a34-f492-43c0-9657-ec7dbbeba236"

#define NS_ISHELLSERVICE_IID \
  {0x7d8a7a34, 0xf492, 0x43c0, \
    { 0x96, 0x57, 0xec, 0x7d, 0xbb, 0xeb, 0xa2, 0x36 }}

class NS_NO_VTABLE nsIShellService : public nsISupports {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_ISHELLSERVICE_IID)

  /**
   * Determines whether or not Firefox is the "Default Browser."
   * This is simply whether or not Firefox is registered to handle 
   * http links. 
   * 
   * @param aStartupCheck true if this is the check being performed
   *                      by the first browser window at startup, 
   *                      false otherwise. 
   */
  /* boolean isDefaultBrowser (in boolean aStartupCheck); */
  NS_IMETHOD IsDefaultBrowser(PRBool aStartupCheck, PRBool *_retval) = 0;

  /**
   * Registers Firefox as the "Default Browser."
   *
   * @param aClaimAllTypes Register Firefox as the handler for 
   *                       additional protocols (ftp, chrome etc)
   *                       and web documents (.html, .xhtml etc).
   * @param aForAllUsers   Whether or not Firefox should attempt
   *                       to become the default browser for all
   *                       users on a multi-user system. 
   */
  /* void setDefaultBrowser (in boolean aClaimAllTypes, in boolean aForAllUsers); */
  NS_IMETHOD SetDefaultBrowser(PRBool aClaimAllTypes, PRBool aForAllUsers) = 0;

  /** 
   * Used to determine whether or not to show a "Set Default Browser"
   * query dialog. This attribute is true if the application is starting
   * up and "browser.shell.checkDefaultBrowser" is true, otherwise it
   * is false.
   */
  /* attribute boolean shouldCheckDefaultBrowser; */
  NS_IMETHOD GetShouldCheckDefaultBrowser(PRBool *aShouldCheckDefaultBrowser) = 0;
  NS_IMETHOD SetShouldCheckDefaultBrowser(PRBool aShouldCheckDefaultBrowser) = 0;

  /** 
   * Flags for positioning/sizing of the Desktop Background image.
   */
  enum { BACKGROUND_TILE = 0 };

  enum { BACKGROUND_STRETCH = 1 };

  enum { BACKGROUND_CENTER = 2 };

  /**
     * Sets the desktop background image using either the HTML <IMG> 
     * element supplied or the background image of the element supplied.
     *
     * @param aImageElement Either a HTML <IMG> element or an element with
     *                      a background image from which to source the
     *                      background image. 
     * @param aPosition     How to place the image on the desktop
     */
  /* void setDesktopBackground (in nsIDOMElement aElement, in long aPosition); */
  NS_IMETHOD SetDesktopBackground(nsIDOMElement *aElement, PRInt32 aPosition) = 0;

  /**
   * Constants identifying preferred applications that can be opened with
   * openPreferredApplication.
   */
  enum { APPLICATION_MAIL = 0 };

  enum { APPLICATION_NEWS = 1 };

  /**
   * Opens the preferred application specified.
   */
  /* void openPreferredApplication (in long aApplication); */
  NS_IMETHOD OpenPreferredApplication(PRInt32 aApplication) = 0;

  /** 
   * The desktop background color, visible when no background image is 
   * used, or if the background image is centered and does not fill the 
   * entire screen. A rgb value, where (r << 16 | g << 8 | b)
   */
  /* attribute unsigned long desktopBackgroundColor; */
  NS_IMETHOD GetDesktopBackgroundColor(PRUint32 *aDesktopBackgroundColor) = 0;
  NS_IMETHOD SetDesktopBackgroundColor(PRUint32 aDesktopBackgroundColor) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSISHELLSERVICE \
  NS_IMETHOD IsDefaultBrowser(PRBool aStartupCheck, PRBool *_retval); \
  NS_IMETHOD SetDefaultBrowser(PRBool aClaimAllTypes, PRBool aForAllUsers); \
  NS_IMETHOD GetShouldCheckDefaultBrowser(PRBool *aShouldCheckDefaultBrowser); \
  NS_IMETHOD SetShouldCheckDefaultBrowser(PRBool aShouldCheckDefaultBrowser); \
  NS_IMETHOD SetDesktopBackground(nsIDOMElement *aElement, PRInt32 aPosition); \
  NS_IMETHOD OpenPreferredApplication(PRInt32 aApplication); \
  NS_IMETHOD GetDesktopBackgroundColor(PRUint32 *aDesktopBackgroundColor); \
  NS_IMETHOD SetDesktopBackgroundColor(PRUint32 aDesktopBackgroundColor); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSISHELLSERVICE(_to) \
  NS_IMETHOD IsDefaultBrowser(PRBool aStartupCheck, PRBool *_retval) { return _to IsDefaultBrowser(aStartupCheck, _retval); } \
  NS_IMETHOD SetDefaultBrowser(PRBool aClaimAllTypes, PRBool aForAllUsers) { return _to SetDefaultBrowser(aClaimAllTypes, aForAllUsers); } \
  NS_IMETHOD GetShouldCheckDefaultBrowser(PRBool *aShouldCheckDefaultBrowser) { return _to GetShouldCheckDefaultBrowser(aShouldCheckDefaultBrowser); } \
  NS_IMETHOD SetShouldCheckDefaultBrowser(PRBool aShouldCheckDefaultBrowser) { return _to SetShouldCheckDefaultBrowser(aShouldCheckDefaultBrowser); } \
  NS_IMETHOD SetDesktopBackground(nsIDOMElement *aElement, PRInt32 aPosition) { return _to SetDesktopBackground(aElement, aPosition); } \
  NS_IMETHOD OpenPreferredApplication(PRInt32 aApplication) { return _to OpenPreferredApplication(aApplication); } \
  NS_IMETHOD GetDesktopBackgroundColor(PRUint32 *aDesktopBackgroundColor) { return _to GetDesktopBackgroundColor(aDesktopBackgroundColor); } \
  NS_IMETHOD SetDesktopBackgroundColor(PRUint32 aDesktopBackgroundColor) { return _to SetDesktopBackgroundColor(aDesktopBackgroundColor); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSISHELLSERVICE(_to) \
  NS_IMETHOD IsDefaultBrowser(PRBool aStartupCheck, PRBool *_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->IsDefaultBrowser(aStartupCheck, _retval); } \
  NS_IMETHOD SetDefaultBrowser(PRBool aClaimAllTypes, PRBool aForAllUsers) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetDefaultBrowser(aClaimAllTypes, aForAllUsers); } \
  NS_IMETHOD GetShouldCheckDefaultBrowser(PRBool *aShouldCheckDefaultBrowser) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetShouldCheckDefaultBrowser(aShouldCheckDefaultBrowser); } \
  NS_IMETHOD SetShouldCheckDefaultBrowser(PRBool aShouldCheckDefaultBrowser) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetShouldCheckDefaultBrowser(aShouldCheckDefaultBrowser); } \
  NS_IMETHOD SetDesktopBackground(nsIDOMElement *aElement, PRInt32 aPosition) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetDesktopBackground(aElement, aPosition); } \
  NS_IMETHOD OpenPreferredApplication(PRInt32 aApplication) { return !_to ? NS_ERROR_NULL_POINTER : _to->OpenPreferredApplication(aApplication); } \
  NS_IMETHOD GetDesktopBackgroundColor(PRUint32 *aDesktopBackgroundColor) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDesktopBackgroundColor(aDesktopBackgroundColor); } \
  NS_IMETHOD SetDesktopBackgroundColor(PRUint32 aDesktopBackgroundColor) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetDesktopBackgroundColor(aDesktopBackgroundColor); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsShellService : public nsIShellService
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSISHELLSERVICE

  nsShellService();

private:
  ~nsShellService();

protected:
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsShellService, nsIShellService)

nsShellService::nsShellService()
{
  /* member initializers and constructor code */
}

nsShellService::~nsShellService()
{
  /* destructor code */
}

/* boolean isDefaultBrowser (in boolean aStartupCheck); */
NS_IMETHODIMP nsShellService::IsDefaultBrowser(PRBool aStartupCheck, PRBool *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setDefaultBrowser (in boolean aClaimAllTypes, in boolean aForAllUsers); */
NS_IMETHODIMP nsShellService::SetDefaultBrowser(PRBool aClaimAllTypes, PRBool aForAllUsers)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute boolean shouldCheckDefaultBrowser; */
NS_IMETHODIMP nsShellService::GetShouldCheckDefaultBrowser(PRBool *aShouldCheckDefaultBrowser)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsShellService::SetShouldCheckDefaultBrowser(PRBool aShouldCheckDefaultBrowser)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setDesktopBackground (in nsIDOMElement aElement, in long aPosition); */
NS_IMETHODIMP nsShellService::SetDesktopBackground(nsIDOMElement *aElement, PRInt32 aPosition)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void openPreferredApplication (in long aApplication); */
NS_IMETHODIMP nsShellService::OpenPreferredApplication(PRInt32 aApplication)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute unsigned long desktopBackgroundColor; */
NS_IMETHODIMP nsShellService::GetDesktopBackgroundColor(PRUint32 *aDesktopBackgroundColor)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsShellService::SetDesktopBackgroundColor(PRUint32 aDesktopBackgroundColor)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


#endif /* __gen_nsIShellService_h__ */
