/*
 * Decompiled with CFR 0.152.
 */
package org.kde.kjas.server;

import java.applet.Applet;
import java.applet.AppletContext;
import java.applet.AppletStub;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.JFrame;
import org.kde.kjas.server.KJASAppletClassLoader;
import org.kde.kjas.server.KJASAppletContext;
import org.kde.kjas.server.KJASAppletPanel;
import org.kde.kjas.server.Main;

public final class KJASAppletStub
implements AppletStub {
    private KJASAppletContext context;
    private Hashtable params;
    private URL codeBase;
    private URL docBase;
    private boolean active;
    private String appletName;
    private String appletID;
    private Dimension appletSize;
    private String windowName;
    private String className;
    private Class appletClass;
    private JFrame frame;
    public static final int ACTION = -1;
    public static final int UNKNOWN = 0;
    public static final int CLASS_LOADED = 1;
    public static final int INSTANCIATED = 2;
    public static final int INITIALIZED = 3;
    public static final int STARTED = 4;
    public static final int STOPPED = 5;
    public static final int DESTROYED = 6;
    private static final int TERMINATE = 7;
    private static final int FAILED = 8;
    KJASAppletClassLoader loader;
    private KJASAppletPanel panel;
    private Applet app;
    KJASAppletStub me;
    private static final int JError = -1;
    private static final int JVoid = 0;
    private static final int JBoolean = 1;
    private static final int JFunction = 2;
    private static final int JNumber = 3;
    private static final int JObject = 4;
    static final int JString = 5;
    private RunThread runThread = null;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;

    public KJASAppletStub(KJASAppletContext kJASAppletContext, String string, URL uRL, URL uRL2, String string2, String string3, Dimension dimension, Hashtable hashtable, String string4, KJASAppletClassLoader kJASAppletClassLoader) {
        this.context = kJASAppletContext;
        this.appletID = string;
        this.codeBase = uRL;
        this.docBase = uRL2;
        this.active = false;
        this.appletName = string2;
        this.className = string3.replace('/', '.');
        this.appletSize = dimension;
        this.params = hashtable;
        this.windowName = string4;
        this.loader = kJASAppletClassLoader;
        String string5 = string3;
        if (string3.endsWith(".class") || string3.endsWith(".CLASS")) {
            string5 = string3.substring(0, string3.length() - 6);
        } else if (string3.endsWith(".java") || string3.endsWith(".JAVA")) {
            string5 = string3.substring(0, string3.length() - 5);
        }
        this.className = string5.replace('/', '.');
        this.appletClass = null;
        this.me = this;
    }

    private void stateChange(int n) {
        Main.protocol.sendAppletStateNotification(this.context.getID(), this.appletID, n);
    }

    private void setFailed(String string) {
        this.loader.removeStatusListener(this.panel);
        this.panel.stopAnimation();
        this.panel.showFailed();
        Main.protocol.sendAppletFailed(this.context.getID(), this.appletID, string);
    }

    void createApplet() {
        this.panel = new KJASAppletPanel();
        this.frame = new JFrame(this.windowName);
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                KJASAppletStub.this.me.destroyApplet();
            }
        });
        this.frame.getContentPane().add((Component)this.panel, "Center");
        if ((double)Main.java_version > 1.399) {
            this.frame.setUndecorated(true);
        }
        this.frame.setLocation(0, 0);
        this.frame.pack();
        if (this.appletSize.getWidth() > 0.0) {
            this.frame.setBounds(0, 0, this.appletSize.width, this.appletSize.height);
        } else {
            this.frame.setBounds(0, 0, 50, 50);
        }
        this.frame.setVisible(true);
        this.loader.addStatusListener(this.panel);
        this.runThread = new RunThread();
        this.runThread.start();
    }

    void startApplet() {
        this.runThread.requestState(4);
    }

    void stopApplet() {
        this.runThread.requestState(5);
    }

    void initApplet() {
        this.runThread.requestState(3);
    }

    synchronized void destroyApplet() {
        this.runThread.requestState(6);
    }

    static void waitForAppletThreads() {
        Thread[] threadArray = new Thread[Thread.activeCount() + 5];
        int n = Thread.enumerate(threadArray);
        for (int i = 0; i < n; ++i) {
            try {
                if (threadArray[i].getName() == null || !threadArray[i].getName().startsWith("KJAS-AppletStub-")) continue;
                try {
                    ((RunThread)threadArray[i]).requestState(7);
                    threadArray[i].join(10000L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    Applet getApplet() {
        if (this.runThread != null && this.runThread.getAppletState() > 1) {
            return this.app;
        }
        return null;
    }

    public String getParameter(String string) {
        return (String)this.params.get(string.toUpperCase());
    }

    public boolean isActive() {
        return this.active;
    }

    boolean isLoaded() {
        return this.runThread != null && this.runThread.getAppletState() >= 2;
    }

    public void appletResize(int n, int n2) {
        if (this.active && n >= 0 && n2 >= 0) {
            Main.debug("Applet #" + this.appletID + ": appletResize to : (" + n + ", " + n2 + ")");
            Main.protocol.sendResizeAppletCmd(this.context.getID(), this.appletID, n, n2);
            this.appletSize = new Dimension(n, n2);
        }
    }

    private static final Object cast(Object object, Class clazz) throws NumberFormatException {
        Object object2 = object;
        if (object == null) {
            object2 = null;
        } else {
            if (clazz.isAssignableFrom(object.getClass())) {
                return object;
            }
            if (object instanceof String) {
                String string = (String)object;
                Main.debug("Argument String: \"" + string + "\"");
                if (clazz == Boolean.TYPE || clazz == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = KJASAppletStub.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
                    object2 = new Boolean(string);
                } else if (clazz == Integer.TYPE || clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = KJASAppletStub.class$("java.lang.Integer")) : class$java$lang$Integer)) {
                    object2 = new Integer(string);
                } else if (clazz == Long.TYPE || clazz == (class$java$lang$Long == null ? (class$java$lang$Long = KJASAppletStub.class$("java.lang.Long")) : class$java$lang$Long)) {
                    object2 = new Long(string);
                } else if (clazz == Float.TYPE || clazz == (class$java$lang$Float == null ? (class$java$lang$Float = KJASAppletStub.class$("java.lang.Float")) : class$java$lang$Float)) {
                    object2 = new Float(string);
                } else if (clazz == Double.TYPE || clazz == (class$java$lang$Double == null ? (class$java$lang$Double = KJASAppletStub.class$("java.lang.Double")) : class$java$lang$Double)) {
                    object2 = new Double(string);
                } else if (clazz == Short.TYPE || clazz == (class$java$lang$Short == null ? (class$java$lang$Short = KJASAppletStub.class$("java.lang.Short")) : class$java$lang$Short)) {
                    object2 = new Short(string);
                } else if (clazz == Byte.TYPE || clazz == (class$java$lang$Byte == null ? (class$java$lang$Byte = KJASAppletStub.class$("java.lang.Byte")) : class$java$lang$Byte)) {
                    object2 = new Byte(string);
                } else if (clazz == Character.TYPE || clazz == (class$java$lang$Character == null ? (class$java$lang$Character = KJASAppletStub.class$("java.lang.Character")) : class$java$lang$Character)) {
                    object2 = new Character(string.charAt(0));
                }
            }
        }
        return object2;
    }

    private Method findMethod(Class clazz, String string, Class[] classArray) {
        try {
            Method[] methodArray = clazz.getMethods();
            for (int i = 0; i < methodArray.length; ++i) {
                Method method = methodArray[i];
                if (!method.getName().equals(string)) continue;
                Main.debug("Candidate: " + method);
                Class<?>[] classArray2 = method.getParameterTypes();
                if (classArray == null) {
                    if (classArray2.length != 0) continue;
                    return method;
                }
                if (classArray.length != classArray2.length) continue;
                for (int j = 0; j < classArray.length; ++j) {
                    classArray[j] = classArray2[j];
                }
                return method;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    private int[] getJSTypeValue(Hashtable hashtable, Object object, int n, StringBuffer stringBuffer) {
        String string = object.toString();
        int[] nArray = new int[]{-1, n};
        String string2 = object.getClass().getName();
        if (string2.equals("boolean") || string2.equals("java.lang.Boolean")) {
            nArray[0] = 1;
        } else if (string2.equals("int") || string2.equals("long") || string2.equals("float") || string2.equals("double") || string2.equals("byte") || object instanceof Number) {
            nArray[0] = 3;
        } else if (string2.equals("java.lang.String")) {
            nArray[0] = 5;
        } else if (!(string2.startsWith("org.kde.kjas.server") || object instanceof Class && ((Class)object).getName().startsWith("org.kde.kjas.server"))) {
            nArray[0] = 4;
            nArray[1] = object.hashCode();
            hashtable.put(new Integer(nArray[1]), object);
        }
        stringBuffer.insert(0, string);
        return nArray;
    }

    boolean putMember(int n, int n2, String string, String string2) {
        if (this.runThread == null) {
            return false;
        }
        this.runThread.requestAction(new PutAction(n, n2, string, string2));
        return true;
    }

    boolean getMember(int n, int n2, String string) {
        if (this.runThread == null) {
            return false;
        }
        this.runThread.requestAction(new GetAction(n, n2, string));
        return true;
    }

    boolean callMember(int n, int n2, String string, List list) {
        if (this.runThread == null) {
            return false;
        }
        this.runThread.requestAction(new CallAction(n, n2, string, list));
        return true;
    }

    public AppletContext getAppletContext() {
        return this.context;
    }

    public URL getCodeBase() {
        return this.codeBase;
    }

    public URL getDocumentBase() {
        return this.docBase;
    }

    public String getAppletName() {
        return this.appletName;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class CallAction
    implements AppletAction {
        int call_id;
        int objid;
        String name;
        List args;

        CallAction(int n, int n2, String string, List list) {
            this.call_id = n;
            this.objid = n2;
            this.name = string;
            this.args = list;
        }

        public void apply() {
            Applet applet;
            StringBuffer stringBuffer = new StringBuffer();
            Hashtable hashtable = KJASAppletStub.this.loader.getJSReferencedObjects();
            int[] nArray = new int[]{-1, this.objid};
            Applet applet2 = applet = this.objid == 0 ? KJASAppletStub.this.getApplet() : hashtable.get(new Integer(this.objid));
            if (applet == null) {
                this.fail();
                return;
            }
            try {
                Main.debug("callMember: " + this.name);
                Class<?> clazz = applet.getClass();
                Class[] classArray = new Class[this.args.size()];
                for (int i = 0; i < this.args.size(); ++i) {
                    classArray[i] = this.name.getClass();
                }
                Method method = KJASAppletStub.this.findMethod(clazz, this.name, classArray);
                Main.debug("Found Method: " + method);
                if (method != null) {
                    Object[] objectArray = new Object[this.args.size()];
                    for (int i = 0; i < this.args.size(); ++i) {
                        objectArray[i] = KJASAppletStub.cast(this.args.get(i), classArray[i]);
                    }
                    Object object = method.invoke((Object)applet, objectArray);
                    if (object == null) {
                        nArray[0] = 0;
                    } else {
                        nArray = KJASAppletStub.this.getJSTypeValue(hashtable, object, this.objid, stringBuffer);
                    }
                }
            }
            catch (Exception exception) {
                Main.debug("callMember threw exception: " + exception.toString());
            }
            Main.protocol.sendMemberValue(KJASAppletStub.this.context.getID(), 17, this.call_id, nArray[0], nArray[1], stringBuffer.toString());
        }

        public void fail() {
            Main.protocol.sendMemberValue(KJASAppletStub.this.context.getID(), 17, this.call_id, -1, 0, "");
        }
    }

    private class GetAction
    implements AppletAction {
        int call_id;
        int objid;
        String name;

        GetAction(int n, int n2, String string) {
            this.call_id = n;
            this.objid = n2;
            this.name = string;
        }

        public void apply() {
            Applet applet;
            Main.debug("getMember: " + this.name);
            StringBuffer stringBuffer = new StringBuffer();
            int[] nArray = new int[]{-1, this.objid};
            Hashtable hashtable = KJASAppletStub.this.loader.getJSReferencedObjects();
            Applet applet2 = applet = this.objid == 0 ? KJASAppletStub.this.getApplet() : hashtable.get(new Integer(this.objid));
            if (applet == null) {
                this.fail();
                return;
            }
            Class<?> clazz = applet.getClass();
            try {
                Field field = clazz.getField(this.name);
                nArray = KJASAppletStub.this.getJSTypeValue(hashtable, field.get(applet), this.objid, stringBuffer);
            }
            catch (Exception exception) {
                Method[] methodArray = clazz.getMethods();
                for (int i = 0; i < methodArray.length; ++i) {
                    if (!methodArray[i].getName().equals(this.name)) continue;
                    nArray[0] = 2;
                    break;
                }
            }
            Main.protocol.sendMemberValue(KJASAppletStub.this.context.getID(), 16, this.call_id, nArray[0], nArray[1], stringBuffer.toString());
        }

        public void fail() {
            Main.protocol.sendMemberValue(KJASAppletStub.this.context.getID(), 16, this.call_id, -1, 0, "");
        }
    }

    private class PutAction
    implements AppletAction {
        int call_id;
        int objid;
        String name;
        String value;

        PutAction(int n, int n2, String string, String string2) {
            this.call_id = n;
            this.objid = n2;
            this.name = string;
            this.value = string2;
        }

        public void apply() {
            block23: {
                Field field;
                Applet applet;
                Hashtable hashtable = KJASAppletStub.this.loader.getJSReferencedObjects();
                Applet applet2 = applet = this.objid == 0 ? KJASAppletStub.this.getApplet() : hashtable.get(new Integer(this.objid));
                if (applet == null) {
                    Main.debug("Error in putValue: object " + this.objid + " not found");
                    this.fail();
                    return;
                }
                try {
                    field = applet.getClass().getField(this.name);
                }
                catch (Exception exception) {
                    this.fail();
                    return;
                }
                if (field == null) {
                    Main.debug("Error in putValue: " + this.name + " not found");
                    this.fail();
                    return;
                }
                try {
                    String string = field.getType().getName();
                    Main.debug("putValue: (" + string + ")" + this.name + "=" + this.value);
                    if (string.equals("boolean")) {
                        field.setBoolean(applet, Boolean.getBoolean(this.value));
                        break block23;
                    }
                    if (string.equals("java.lang.Boolean")) {
                        field.set(applet, Boolean.valueOf(this.value));
                        break block23;
                    }
                    if (string.equals("int")) {
                        field.setInt(applet, Integer.parseInt(this.value));
                        break block23;
                    }
                    if (string.equals("java.lang.Integer")) {
                        field.set(applet, Integer.valueOf(this.value));
                        break block23;
                    }
                    if (string.equals("byte")) {
                        field.setByte(applet, Byte.parseByte(this.value));
                        break block23;
                    }
                    if (string.equals("java.lang.Byte")) {
                        field.set(applet, Byte.valueOf(this.value));
                        break block23;
                    }
                    if (string.equals("char")) {
                        field.setChar(applet, this.value.charAt(0));
                        break block23;
                    }
                    if (string.equals("java.lang.Character")) {
                        field.set(applet, new Character(this.value.charAt(0)));
                        break block23;
                    }
                    if (string.equals("double")) {
                        field.setDouble(applet, Double.parseDouble(this.value));
                        break block23;
                    }
                    if (string.equals("java.lang.Double")) {
                        field.set(applet, Double.valueOf(this.value));
                        break block23;
                    }
                    if (string.equals("float")) {
                        field.setFloat(applet, Float.parseFloat(this.value));
                        break block23;
                    }
                    if (string.equals("java.lang.Float")) {
                        field.set(applet, Float.valueOf(this.value));
                        break block23;
                    }
                    if (string.equals("long")) {
                        field.setLong(applet, Long.parseLong(this.value));
                        break block23;
                    }
                    if (string.equals("java.lang.Long")) {
                        field.set(applet, Long.valueOf(this.value));
                        break block23;
                    }
                    if (string.equals("short")) {
                        field.setShort(applet, Short.parseShort(this.value));
                        break block23;
                    }
                    if (string.equals("java.lang.Short")) {
                        field.set(applet, Short.valueOf(this.value));
                        break block23;
                    }
                    if (string.equals("java.lang.String")) {
                        field.set(applet, this.value);
                        break block23;
                    }
                    Main.debug("Error putValue: unsupported type: " + string);
                    this.fail();
                    return;
                }
                catch (Exception exception) {
                    Main.debug("Exception in putValue: " + exception.getMessage());
                    this.fail();
                    return;
                }
            }
            Main.protocol.sendPutMember(KJASAppletStub.this.context.getID(), this.call_id, true);
        }

        public void fail() {
            Main.protocol.sendPutMember(KJASAppletStub.this.context.getID(), this.call_id, false);
        }
    }

    private class RunThread
    extends Thread {
        private int request_state = 1;
        private int current_state = 0;
        private Vector actions = new Vector();
        private AccessControlContext acc = null;

        RunThread() {
            super("KJAS-AppletStub-" + KJASAppletStub.this.appletID + "-" + KJASAppletStub.this.appletName);
            this.setContextClassLoader(KJASAppletStub.this.loader);
        }

        synchronized void requestState(int n) {
            if (n > this.current_state) {
                this.request_state = n;
                this.notifyAll();
            }
        }

        synchronized void requestAction(AppletAction appletAction) {
            this.actions.add(appletAction);
            this.notifyAll();
        }

        private synchronized int getRequestState() {
            while (this.request_state == this.current_state) {
                if (!this.actions.isEmpty()) {
                    if (this.current_state >= 3 && this.current_state < 5) {
                        return -1;
                    }
                    AppletAction appletAction = (AppletAction)this.actions.remove(0);
                    appletAction.fail();
                    continue;
                }
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.request_state == 6 && this.current_state == 4) {
                return this.current_state + 1;
            }
            return this.request_state;
        }

        synchronized int getAppletState() {
            return this.current_state;
        }

        private synchronized void setState(int n) {
            this.current_state = n;
        }

        private void doState(int n) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
            switch (n) {
                case 1: {
                    KJASAppletStub.this.appletClass = KJASAppletStub.this.loader.loadClass(KJASAppletStub.this.className);
                    this.requestState(2);
                    break;
                }
                case 2: {
                    Object var2_2 = null;
                    try {
                        var2_2 = KJASAppletStub.this.appletClass.newInstance();
                        KJASAppletStub.this.app = var2_2;
                    }
                    catch (ClassCastException classCastException) {
                        if (var2_2 != null && var2_2 instanceof Component) {
                            KJASAppletStub.this.app = new Applet();
                            KJASAppletStub.this.app.setLayout(new BorderLayout());
                            KJASAppletStub.this.app.add((Component)var2_2, "Center");
                        }
                        throw classCastException;
                    }
                    this.acc = new AccessControlContext(new ProtectionDomain[]{KJASAppletStub.this.app.getClass().getProtectionDomain()});
                    this.requestState(3);
                    break;
                }
                case 3: {
                    KJASAppletStub.this.app.setStub(KJASAppletStub.this.me);
                    KJASAppletStub.this.app.setVisible(false);
                    KJASAppletStub.this.panel.setApplet(KJASAppletStub.this.app);
                    if (KJASAppletStub.this.appletSize.getWidth() > 0.0) {
                        KJASAppletStub.this.app.setBounds(0, 0, ((KJASAppletStub)KJASAppletStub.this).appletSize.width, ((KJASAppletStub)KJASAppletStub.this).appletSize.height);
                    } else {
                        KJASAppletStub.this.app.setBounds(0, 0, ((KJASAppletStub)KJASAppletStub.this).panel.getSize().width, ((KJASAppletStub)KJASAppletStub.this).panel.getSize().height);
                    }
                    KJASAppletStub.this.app.init();
                    KJASAppletStub.this.loader.removeStatusListener(KJASAppletStub.this.panel);
                    KJASAppletStub.this.app.setVisible(true);
                    KJASAppletStub.this.panel.stopAnimation();
                    break;
                }
                case 4: {
                    KJASAppletStub.this.active = true;
                    KJASAppletStub.this.app.start();
                    KJASAppletStub.this.frame.validate();
                    KJASAppletStub.this.app.repaint();
                    break;
                }
                case 5: {
                    KJASAppletStub.this.active = false;
                    KJASAppletStub.this.app.stop();
                    if ((double)Main.java_version > 1.399) {
                        WindowListener[] windowListenerArray = KJASAppletStub.this.frame.getWindowListeners();
                        for (int i = 0; windowListenerArray != null && i < windowListenerArray.length; ++i) {
                            KJASAppletStub.this.frame.removeWindowListener(windowListenerArray[i]);
                        }
                    }
                    KJASAppletStub.this.frame.setVisible(false);
                    break;
                }
                case 6: {
                    KJASAppletStub.this.app.destroy();
                    KJASAppletStub.this.frame.dispose();
                    KJASAppletStub.this.app = null;
                    this.requestState(7);
                    break;
                }
                default: {
                    return;
                }
            }
        }

        public void run() {
            int n;
            while ((n = this.getRequestState()) < 7) {
                if (n == -1) {
                    AccessController.doPrivileged(new PrivilegedAction(this){
                        private final /* synthetic */ RunThread this$1;
                        {
                            this.this$1 = runThread;
                        }

                        public Object run() {
                            AppletAction appletAction = (AppletAction)RunThread.access$900(this.this$1).remove(0);
                            try {
                                appletAction.apply();
                            }
                            catch (Exception exception) {
                                Main.debug("Error during action " + exception);
                                appletAction.fail();
                            }
                            return null;
                        }
                    }, this.acc);
                    continue;
                }
                try {
                    this.doState(n);
                }
                catch (Exception exception) {
                    Main.kjas_err("Error during state " + n, exception);
                    if (n < 3) {
                        this.setState(8);
                        KJASAppletStub.this.setFailed(exception.toString());
                        return;
                    }
                }
                catch (Throwable throwable) {
                    this.setState(8);
                    KJASAppletStub.this.setFailed(throwable.toString());
                    return;
                }
                this.setState(n);
                KJASAppletStub.this.stateChange(n);
            }
            return;
        }

        static /* synthetic */ Vector access$900(RunThread runThread) {
            return runThread.actions;
        }
    }

    static interface AppletAction {
        public void apply();

        public void fail();
    }
}

