//Auto-generated by kalyptus. DO NOT EDIT.
package org.kde.koala;

import org.kde.qt.Qt;
import org.kde.qt.QMetaObject;
import org.kde.qt.QtSupport;
import java.util.ArrayList;
import org.kde.qt.QWidget;
import org.kde.qt.QObject;

/**

 To open files with their associated applications in KDE, use KRun.
 It can execute any desktop entry, as well as any file, using
 the default application or another application "bound" to the file type
 (or URL protocol).
 In that example, the mimetype of the file is not known by the application,
 so a KRun instance must be created. It will determine the mimetype by itself.
 If the mimetype is known, or if you even know the service (application) to
 use for this file, use one of the static methods.
 By default KRun uses auto deletion. It causes the KRun instance to delete
 itself when the it finished its task. If you allocate the KRun
 object on the stack you must disable auto deletion, otherwise it will crash.
 See {@link KRunSignals} for signals emitted by KRun
		@short Opens files with their associated applications in KDE.

*/
public class KRun extends QObject  {
	protected KRun(Class dummy){super((Class) null);}
	public native QMetaObject metaObject();
	public native String className();
	/**	
		 Create a KRun object to run the preferred application for a file/URL.
		 KRun will first determine the type of the file, and will then
		 run the associated application.
			@param url the URL of the file or directory to 'run'
			@param mode The <code>st_mode</code> field of <tt>struct stat</tt>. If
		        you don't know this set it to 0.
			@param isLocalFile         If this parameter is set to <code>false</code> then <code>url</code> is
		        examined to find out whether it is a local URL or
		        not. This flag is just used to improve speed, since the
		        function KURL.isLocalFile is a bit slow.
			@param showProgressInfo         Whether to show progress information when determining the
		        type of the file (i.e. when using KIO.stat and KIO.mimetype)
		        Before you set this to false to avoid a dialog box, think about
		        a very slow FTP server...
		        It is always better to provide progress info in such cases.
		   		@short    Create a KRun object to run the preferred application for a file/URL.
	*/
	public KRun(KURL url, long mode, boolean isLocalFile, boolean showProgressInfo) {
		super((Class) null);
		newKRun(url,mode,isLocalFile,showProgressInfo);
	}
	private native void newKRun(KURL url, long mode, boolean isLocalFile, boolean showProgressInfo);
	public KRun(KURL url, long mode, boolean isLocalFile) {
		super((Class) null);
		newKRun(url,mode,isLocalFile);
	}
	private native void newKRun(KURL url, long mode, boolean isLocalFile);
	public KRun(KURL url, long mode) {
		super((Class) null);
		newKRun(url,mode);
	}
	private native void newKRun(KURL url, long mode);
	public KRun(KURL url) {
		super((Class) null);
		newKRun(url);
	}
	private native void newKRun(KURL url);
	/**	
		 BIC: Combine with the above ctor for KDE 4.0.
			@param window         The top-level widget of the app that invoked this object.
		        It is used to make sure private information like passwords
		        are properly handled per application.
			@param url the URL of the file or directory to 'run'
			@param mode The <code>st_mode</code> field of <tt>struct stat</tt>. If
		        you don't know this set it to 0.
			@param isLocalFile         If this parameter is set to <code>false</code> then <code>url</code> is
		        examined to find out whether it is a local URL or
		        not. This flag is just used to improve speed, since the
		        function KURL.isLocalFile is a bit slow.
			@param showProgressInfo         Whether to show progress information when determining the
		        type of the file (i.e. when using KIO.stat and KIO.mimetype)
		        Before you set this to false to avoid a dialog box, think about
		        a very slow FTP server...
		        It is always better to provide progress info in such cases.
		   		@short    BIC: Combine with the above ctor for KDE 4.
	*/
	public KRun(KURL url, QWidget window, long mode, boolean isLocalFile, boolean showProgressInfo) {
		super((Class) null);
		newKRun(url,window,mode,isLocalFile,showProgressInfo);
	}
	private native void newKRun(KURL url, QWidget window, long mode, boolean isLocalFile, boolean showProgressInfo);
	public KRun(KURL url, QWidget window, long mode, boolean isLocalFile) {
		super((Class) null);
		newKRun(url,window,mode,isLocalFile);
	}
	private native void newKRun(KURL url, QWidget window, long mode, boolean isLocalFile);
	public KRun(KURL url, QWidget window, long mode) {
		super((Class) null);
		newKRun(url,window,mode);
	}
	private native void newKRun(KURL url, QWidget window, long mode);
	public KRun(KURL url, QWidget window) {
		super((Class) null);
		newKRun(url,window);
	}
	private native void newKRun(KURL url, QWidget window);
	/**	
		 Abort this KRun. This kills any jobs launched by it,
		 and leads to deletion if auto-deletion is on.
		 This is much safer than deleting the KRun (in case it's
		 currently showing an error dialog box, for instance)
		   		@short    Abort this KRun.
	*/
	public native void abort();
	/**	
		 Returns true if the KRun instance has an error.
				@return true when an error occurred

		@short    Returns true if the KRun instance has an error.
		@see #error
	*/
	public native boolean hasError();
	/**	
		 Returns true if the KRun instance has finished.
				@return true if the KRun instance has finished

		@short    Returns true if the KRun instance has finished.
		@see #finished
	*/
	public native boolean hasFinished();
	/**	
		 Checks whether auto delete is activated.
		 Auto-deletion causes the KRun instance to delete itself
		 when it finished its task.
		 By default auto deletion is on.
				@return true if auto deletion is on, false otherwise
   
		@short    Checks whether auto delete is activated.
	*/
	public native boolean autoDelete();
	/**	
		 Enables or disabled auto deletion.
		 Auto deletion causes the KRun instance to delete itself
		 when it finished its task. If you allocate the KRun
		 object on the stack you must disable auto deletion.
		 By default auto deletion is on.
			@param b true to enable auto deletion, false to disable
		   		@short    Enables or disabled auto deletion.
	*/
	public native void setAutoDelete(boolean b);
	/**	
		 Set the preferred service for opening this URL, after
		 its mimetype will have been found by KRun. IMPORTANT: the service is
		 only used if its configuration says it can handle this mimetype.
		 This is used for instance for the X-KDE-LastOpenedWith key, for
		 the recent documents list.
			@param desktopEntryName the desktopEntryName of the service, e.g. "kate".
		   		@short    Set the preferred service for opening this URL, after  its mimetype will have been found by KRun.
	*/
	public native void setPreferredService(String desktopEntryName);
	/**	
		 Sets whether executables, .desktop files or shell scripts should
		 be run by KRun. This is enabled by default.
			@param b whether to run executable files or not.
				@short    Sets whether executables, .
		@see #isExecutable
	*/
	public native void setRunExecutables(boolean b);
	/**	
		 Sets whether the external webbrowser setting should be honoured.
		 This is enabled by default.
		 This should only be disabled in webbrowser applications.
			@param b whether to enable the external browser or not.
				@short    Sets whether the external webbrowser setting should be honoured.
	*/
	public native void setEnableExternalBrowser(boolean b);
	/**	
		 Open a list of URLs with a certain service (application).
			@param _service the service to run
			@param _urls the list of URLs, can be empty (app launched
		        without argument)
			@param tempFiles if true and _urls are local files, they will be deleted
		        when the application exits.
				@return the process id, or 0 on error
   
		@short    Open a list of URLs with a certain service (application).
	*/
	public static native int run(KService _service, ArrayList _urls, boolean tempFiles);
	public static native int run(KService _service, ArrayList _urls);
	/**	
		 Open a list of URLs with.
			@param _exec The name of the executable, for example
		        "/usr/bin/netscape".
			@param _name The logical name of the application, for example
		        "Netscape 4.06".
			@param _icon The icon which should be used by the application.
			@param _obsolete1 Do not use!
			@param _obsolete2 Do not use!
				@return the process id, or 0 on error
   
		@short    Open a list of URLs with.
	*/
	public static native int run(String _exec, ArrayList _urls, String _name, String _icon, String _obsolete1, String _obsolete2);
	public static native int run(String _exec, ArrayList _urls, String _name, String _icon, String _obsolete1);
	public static native int run(String _exec, ArrayList _urls, String _name, String _icon);
	public static native int run(String _exec, ArrayList _urls, String _name);
	public static native int run(String _exec, ArrayList _urls);
	/**	
		 Open the given URL.
			 This function is used after the mime type
		 is found out. It will search for all services which can handle
		 the mime type and call run() afterwards.
			@param _url the URL to open
			@param _mimetype the mime type of the resource
			@param tempFile if true and _url is a local file, it will be deleted
		        when the launched application exits.
			@param runExecutables if false then local .desktop files, 
		        executables and shell scripts will not be run.
		        See also isExecutable().
				@return the process id, or 0 on error
   
		@short    Open the given URL.
	*/
	public static native int runURL(KURL _url, String _mimetype, boolean tempFile, boolean runExecutables);
	public static native int runURL(KURL _url, String _mimetype, boolean tempFile);
	public static native int runURL(KURL _url, String _mimetype);
	/**	
		 Run the given shell command and notifies kicker of the starting
		 of the application. If the program to be called doesn't exist,
		 an error box will be displayed.
			 Use only when you know the full command line. Otherwise use the other
		 static methods, or KRun's constructor.
			 <code>_cmd</code> must be a shell command. You must not append "&"
		 to it, since the function will do that for you.
				@return PID of running command, 0 if it could not be started, 0 - (PID
 of running command) if command was unsafe for map notification.
   
		@short    Run the given shell command and notifies kicker of the starting  of the application.
	*/
	public static native int runCommand(String cmd);
	/**	
		 Same as the other runCommand(), but it also takes the name of the
		 binary, to display an error message in case it couldn't find it.
			 <code>_cmd</code> must be a shell command. You must not append "&"
		 to it, since the function will do that for you.
			@param execName the name of the executable
			@param icon icon for app starting notification
				@return PID of running command, 0 if it could not be started, 0 - (PID
 of running command) if command was unsafe for map notification.
   
		@short    Same as the other runCommand(), but it also takes the name of the  binary, to display an error message in case it couldn't find it.
	*/
	public static native int runCommand(String cmd, String execName, String icon);
	/**	
		 Display the Open-With dialog for those URLs, and run the chosen application.
			@param lst the list of applications to run
			@param tempFiles if true and lst are local files, they will be deleted
		        when the application exits.
				@return false if the dialog was canceled
   
		@short    Display the Open-With dialog for those URLs, and run the chosen application.
	*/
	public static native boolean displayOpenWithDialog(ArrayList lst, boolean tempFiles);
	public static native boolean displayOpenWithDialog(ArrayList lst);
	/**	
		 Quotes a string for the shell.
			@param _str the string to quote. The quoted string will be written here
		   		@short    Quotes a string for the shell.
	*/
	public static native void shellQuote(StringBuffer _str);
	/**	
		 Processes a Exec= line as found in .desktop files.
			@param _service the service to extract information from.
			@param _urls The urls the service should open.
			@param has_shell If true, the arguments are going to be fed into a
		        shell e.g by using system().
		        If false, the arguments are going to be fed into a exec() kind
		        call.
		        If the arguments are intended for an exec() kind of call and
		        the Exec line contains shell commands then "/bin/sh -c" is added.
			@param tempFiles if true and _urls are local files, they will be deleted
		        when the application exits.
				@return a list of arguments suitable for either system() or exec().
   
		@short    Processes a Exec= line as found in .
	*/
	public static native ArrayList processDesktopExec(KService _service, ArrayList _urls, boolean has_shell, boolean tempFiles);
	public static native ArrayList processDesktopExec(KService _service, ArrayList _urls, boolean has_shell);
	/**	
		 Given a full command line (e.g. the Exec= line from a .desktop file),
		 extract the name of the binary being run.
			@param execLine the full command line
			@param removePath if true, remove a (relative or absolute) path. E.g. /usr/bin/ls becomes ls.
				@return the name of the binary to run

		@short    Given a full command line (e.
	*/
	public static native String binaryName(String execLine, boolean removePath);
	/**	
		 Returns whether <code>serviceType</code> refers to an executable program instead
		 of a data file.
				@short    Returns whether <code>serviceType</code> refers to an executable program instead  of a data file.
	*/
	public static native boolean isExecutable(String serviceType);
	/**	
		 Returns wether the <code>url</code> of <code>mimetype</code> is executable.
		 To be executable the file must pass the following rules:
		 -# Must reside on the local filesystem.
		 -# Must be marked as executable for the user by the filesystem.
		 -# The mime type must inherit application/x-executable or application/x-executable-script.
		 To allow a script to run when the above rules are satisfied add the entry
		 @code
		 X-KDE-IsAlso=application/x-executable-script
		 @endcode 
		 to the mimetype's desktop file.
				@short    Returns wether the <code>url</code> of <code>mimetype</code> is executable.
	*/
	public static native boolean isExecutableFile(KURL url, String mimetype);
	/**	
				@short
	*/
	public static native boolean checkStartupNotify(String binName, KService service, boolean[] silent_arg, StringBuffer wmclass_arg);
	protected native void init();
	protected native void scanFile();
	/**	
		 Called if the mimetype has been detected. The function checks
		 whether the document and appends the gzip protocol to the
		 URL. Otherwise runURL is called to finish the job.
		   		@short    Called if the mimetype has been detected.
	*/
	protected native void foundMimeType(String _type);
	protected native void killJob();
	protected native void slotTimeout();
	protected native void slotScanFinished(Job arg1);
	protected native void slotScanMimeType(Job arg1, String type);
	protected native void slotStatResult(Job arg1);
	/** Deletes the wrapped C++ instance */
	protected native void finalize() throws InternalError;
	/** Delete the wrapped C++ instance ahead of finalize() */
	public native void dispose();
	/** Has the wrapped C++ instance been deleted? */
	public native boolean isDisposed();
}
