#!/bin/sh
config() {
  NEW="$1"
  OLD="`dirname $NEW`/`basename $NEW .new`"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "`cat $OLD | md5sum`" = "`cat $NEW | md5sum`" ]; then # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}
config etc/foomatic/filter.conf.new
( cd usr/lib/cups/filter ; rm -rf foomatic-rip )
( cd usr/lib/cups/filter ; ln -sf /usr/bin/foomatic-rip foomatic-rip )
( cd usr/lib/ppr/interfaces ; rm -rf foomatic-rip )
( cd usr/lib/ppr/interfaces ; ln -sf /usr/bin/foomatic-rip foomatic-rip )
( cd usr/lib/ppr/lib ; rm -rf foomatic-rip )
( cd usr/lib/ppr/lib ; ln -sf /usr/bin/foomatic-rip foomatic-rip )
