#!/bin/sh
config() {
  NEW="$1"
  OLD="`dirname $NEW`/`basename $NEW .new`"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "`cat $OLD | md5sum`" = "`cat $NEW | md5sum`" ]; then # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}
config etc/nntpserver.new
# If you already have a different etc/nntpserver then this one is useless:
rm -f etc/nntpserver.new

( cd usr/bin ; rm -rf nnadmin )
( cd usr/bin ; ln -sf nn nnadmin )
( cd usr/bin ; rm -rf nnbatch )
( cd usr/bin ; ln -sf nn nnbatch )
( cd usr/bin ; rm -rf nncheck )
( cd usr/bin ; ln -sf nn nncheck )
( cd usr/bin ; rm -rf nngoback )
( cd usr/bin ; ln -sf nn nngoback )
( cd usr/bin ; rm -rf nngrep )
( cd usr/bin ; ln -sf nn nngrep )
( cd usr/bin ; rm -rf nnpost )
( cd usr/bin ; ln -sf nn nnpost )
( cd usr/bin ; rm -rf nntidy )
( cd usr/bin ; ln -sf nn nntidy )
( cd usr/bin ; rm -rf nnview )
( cd usr/bin ; ln -sf nn nnview )
