/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.dns;

import com.sun.jndi.dns.DnsContext;
import com.sun.jndi.dns.DnsUrl;
import com.sun.jndi.toolkit.url.UrlUtil;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import sun.net.dns.ResolverConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DnsContextFactory
implements InitialContextFactory {
    private static final String DEFAULT_URL = "dns:";

    @Override
    public Context getInitialContext(Hashtable<?, ?> hashtable) throws NamingException {
        if (hashtable == null) {
            hashtable = new Hashtable(5);
        }
        return DnsContextFactory.urlToContext(DnsContextFactory.getInitCtxUrl(hashtable), hashtable);
    }

    public static DnsContext getContext(String string, String[] stringArray, Hashtable<?, ?> hashtable) throws NamingException {
        return new DnsContext(string, stringArray, hashtable);
    }

    public static DnsContext getContext(String string, DnsUrl[] dnsUrlArray, Hashtable hashtable) throws NamingException {
        String[] stringArray = DnsContextFactory.serversForUrls(dnsUrlArray);
        DnsContext dnsContext = DnsContextFactory.getContext(string, stringArray, hashtable);
        if (DnsContextFactory.platformServersUsed(dnsUrlArray)) {
            dnsContext.setProviderUrl(DnsContextFactory.constructProviderUrl(string, stringArray));
        }
        return dnsContext;
    }

    public static boolean platformServersAvailable() {
        return !ResolverConfiguration.open().nameservers().isEmpty();
    }

    private static Context urlToContext(String string, Hashtable hashtable) throws NamingException {
        DnsUrl[] dnsUrlArray;
        try {
            dnsUrlArray = DnsUrl.fromList(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new ConfigurationException(malformedURLException.getMessage());
        }
        if (dnsUrlArray.length == 0) {
            throw new ConfigurationException("Invalid DNS pseudo-URL(s): " + string);
        }
        String string2 = dnsUrlArray[0].getDomain();
        for (int i = 1; i < dnsUrlArray.length; ++i) {
            if (string2.equalsIgnoreCase(dnsUrlArray[i].getDomain())) continue;
            throw new ConfigurationException("Conflicting domains: " + string);
        }
        return DnsContextFactory.getContext(string2, dnsUrlArray, hashtable);
    }

    private static String[] serversForUrls(DnsUrl[] dnsUrlArray) throws NamingException {
        if (dnsUrlArray.length == 0) {
            throw new ConfigurationException("DNS pseudo-URL required");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < dnsUrlArray.length; ++i) {
            List list;
            String string = dnsUrlArray[i].getHost();
            int n = dnsUrlArray[i].getPort();
            if (string == null && n < 0 && !(list = ResolverConfiguration.open().nameservers()).isEmpty()) {
                arrayList.addAll(list);
                continue;
            }
            if (string == null) {
                string = "localhost";
            }
            arrayList.add(n < 0 ? string : string + ":" + n);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private static boolean platformServersUsed(DnsUrl[] dnsUrlArray) {
        if (!DnsContextFactory.platformServersAvailable()) {
            return false;
        }
        for (int i = 0; i < dnsUrlArray.length; ++i) {
            if (dnsUrlArray[i].getHost() != null || dnsUrlArray[i].getPort() >= 0) continue;
            return true;
        }
        return false;
    }

    private static String constructProviderUrl(String string, String[] stringArray) {
        String string2 = "";
        if (!string.equals(".")) {
            try {
                string2 = "/" + UrlUtil.encode(string, "ISO-8859-1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append("dns://").append(stringArray[i]).append(string2);
        }
        return stringBuffer.toString();
    }

    private static String getInitCtxUrl(Hashtable hashtable) {
        String string = (String)hashtable.get("java.naming.provider.url");
        return string != null ? string : DEFAULT_URL;
    }
}

