/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.addressing;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.stream.buffer.XMLStreamBufferSource;
import com.sun.xml.internal.stream.buffer.stax.StreamWriterBufferCreator;
import com.sun.xml.internal.ws.addressing.v200408.MemberSubmissionAddressingConstants;
import com.sun.xml.internal.ws.api.addressing.AddressingVersion;
import com.sun.xml.internal.ws.developer.MemberSubmissionEndpointReference;
import com.sun.xml.internal.ws.util.DOMUtil;
import com.sun.xml.internal.ws.util.xml.XmlUtil;
import com.sun.xml.internal.ws.wsdl.parser.WSDLConstants;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointReferenceUtil {
    private static boolean w3cMetadataWritten = false;

    public static <T extends EndpointReference> T transform(Class<T> clazz, @NotNull EndpointReference endpointReference) {
        assert (endpointReference != null);
        if (clazz.isAssignableFrom(W3CEndpointReference.class)) {
            if (endpointReference instanceof W3CEndpointReference) {
                return (T)endpointReference;
            }
            if (endpointReference instanceof MemberSubmissionEndpointReference) {
                return (T)EndpointReferenceUtil.toW3CEpr((MemberSubmissionEndpointReference)endpointReference);
            }
        } else if (clazz.isAssignableFrom(MemberSubmissionEndpointReference.class)) {
            if (endpointReference instanceof W3CEndpointReference) {
                return (T)EndpointReferenceUtil.toMSEpr((W3CEndpointReference)endpointReference);
            }
            if (endpointReference instanceof MemberSubmissionEndpointReference) {
                return (T)endpointReference;
            }
        }
        throw new WebServiceException("Unknwon EndpointReference: " + endpointReference.getClass());
    }

    private static W3CEndpointReference toW3CEpr(MemberSubmissionEndpointReference memberSubmissionEndpointReference) {
        StreamWriterBufferCreator streamWriterBufferCreator = new StreamWriterBufferCreator();
        w3cMetadataWritten = false;
        try {
            streamWriterBufferCreator.writeStartDocument();
            streamWriterBufferCreator.writeStartElement(AddressingVersion.W3C.getPrefix(), "EndpointReference", AddressingVersion.W3C.nsUri);
            streamWriterBufferCreator.writeNamespace(AddressingVersion.W3C.getPrefix(), AddressingVersion.W3C.nsUri);
            streamWriterBufferCreator.writeStartElement(AddressingVersion.W3C.getPrefix(), "Address", AddressingVersion.W3C.nsUri);
            streamWriterBufferCreator.writeCharacters(memberSubmissionEndpointReference.addr.uri);
            streamWriterBufferCreator.writeEndElement();
            if (memberSubmissionEndpointReference.referenceProperties != null && memberSubmissionEndpointReference.referenceProperties.elements.size() > 0 || memberSubmissionEndpointReference.referenceParameters != null && memberSubmissionEndpointReference.referenceParameters.elements.size() > 0) {
                streamWriterBufferCreator.writeStartElement(AddressingVersion.W3C.getPrefix(), "ReferenceParameters", AddressingVersion.W3C.nsUri);
                if (memberSubmissionEndpointReference.referenceProperties != null) {
                    for (Element object : memberSubmissionEndpointReference.referenceProperties.elements) {
                        DOMUtil.serializeNode(object, streamWriterBufferCreator);
                    }
                }
                if (memberSubmissionEndpointReference.referenceParameters != null) {
                    for (Element element : memberSubmissionEndpointReference.referenceParameters.elements) {
                        DOMUtil.serializeNode(element, streamWriterBufferCreator);
                    }
                }
                streamWriterBufferCreator.writeEndElement();
            }
            Object object = null;
            if (memberSubmissionEndpointReference.elements != null && memberSubmissionEndpointReference.elements.size() > 0) {
                for (Element element : memberSubmissionEndpointReference.elements) {
                    NodeList nodeList;
                    if (!element.getNamespaceURI().equals(MemberSubmissionAddressingConstants.MEX_METADATA.getNamespaceURI()) || !element.getLocalName().equals(MemberSubmissionAddressingConstants.MEX_METADATA.getLocalPart()) || (nodeList = element.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/", WSDLConstants.QNAME_DEFINITIONS.getLocalPart())) == null) continue;
                    object = (Element)nodeList.item(0);
                }
            }
            if (object != null) {
                DOMUtil.serializeNode(object, streamWriterBufferCreator);
            }
            if (w3cMetadataWritten) {
                streamWriterBufferCreator.writeEndElement();
            }
            if (memberSubmissionEndpointReference.elements != null && memberSubmissionEndpointReference.elements.size() > 0) {
                for (Element element : memberSubmissionEndpointReference.elements) {
                    if (!element.getNamespaceURI().equals("http://schemas.xmlsoap.org/wsdl/") || element.getLocalName().equals(WSDLConstants.QNAME_DEFINITIONS.getLocalPart())) {
                        // empty if block
                    }
                    DOMUtil.serializeNode(element, streamWriterBufferCreator);
                }
            }
            streamWriterBufferCreator.writeEndElement();
            streamWriterBufferCreator.writeEndDocument();
            streamWriterBufferCreator.flush();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new WebServiceException(xMLStreamException);
        }
        return new W3CEndpointReference(new XMLStreamBufferSource(streamWriterBufferCreator.getXMLStreamBuffer()));
    }

    private static void writeW3CMetadata(StreamWriterBufferCreator streamWriterBufferCreator) throws XMLStreamException {
        if (!w3cMetadataWritten) {
            streamWriterBufferCreator.writeStartElement(AddressingVersion.W3C.getPrefix(), "Metadata", AddressingVersion.W3C.nsUri);
            w3cMetadataWritten = true;
        }
    }

    private static MemberSubmissionEndpointReference toMSEpr(W3CEndpointReference w3CEndpointReference) {
        DOMResult dOMResult = new DOMResult();
        w3CEndpointReference.writeTo(dOMResult);
        Node node = dOMResult.getNode();
        Element element = DOMUtil.getFirstElementChild(node);
        if (element == null) {
            return null;
        }
        MemberSubmissionEndpointReference memberSubmissionEndpointReference = new MemberSubmissionEndpointReference();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Object object;
            Object object2;
            Node node2;
            if (nodeList.item(i).getNodeType() == 1) {
                node2 = (Element)nodeList.item(i);
                if (node2.getNamespaceURI().equals(AddressingVersion.W3C.nsUri) && node2.getLocalName().equals("Address")) {
                    if (memberSubmissionEndpointReference.addr == null) {
                        memberSubmissionEndpointReference.addr = new MemberSubmissionEndpointReference.Address();
                    }
                    memberSubmissionEndpointReference.addr.uri = XmlUtil.getTextForNode(node2);
                    memberSubmissionEndpointReference.addr.attributes = EndpointReferenceUtil.getAttributes(node2);
                    continue;
                }
                if (node2.getNamespaceURI().equals(AddressingVersion.W3C.nsUri) && node2.getLocalName().equals("ReferenceParameters")) {
                    object2 = node2.getChildNodes();
                    for (int j = 0; j < object2.getLength(); ++j) {
                        if (object2.item(j).getNodeType() != 1) continue;
                        if (memberSubmissionEndpointReference.referenceParameters == null) {
                            memberSubmissionEndpointReference.referenceParameters = new MemberSubmissionEndpointReference.Elements();
                            memberSubmissionEndpointReference.referenceParameters.elements = new ArrayList<Element>();
                        }
                        memberSubmissionEndpointReference.referenceParameters.elements.add((Element)object2.item(i));
                    }
                    continue;
                }
                if (node2.getNamespaceURI().equals(AddressingVersion.W3C.nsUri) && node2.getLocalName().equals("Metadata")) {
                    object2 = node2.getChildNodes();
                    for (int j = 0; j < object2.getLength(); ++j) {
                        String string;
                        Object object3;
                        Object object4;
                        Object object5;
                        object = object2.item(j);
                        if (object.getNodeType() != 1) continue;
                        Element element2 = (Element)object;
                        if (element2.getNamespaceURI().equals(AddressingVersion.W3C.wsdlNsUri) && element2.getLocalName().equals("ServiceName")) {
                            memberSubmissionEndpointReference.serviceName = new MemberSubmissionEndpointReference.ServiceNameType();
                            memberSubmissionEndpointReference.serviceName.portName = element2.getAttribute("EndpointName");
                            object5 = element2.getTextContent();
                            object4 = XmlUtil.getPrefix((String)object5);
                            object3 = XmlUtil.getLocalPart((String)object5);
                            if (object3 == null) continue;
                            if (object4 != null) {
                                string = element2.lookupNamespaceURI((String)object4);
                                if (string != null) {
                                    memberSubmissionEndpointReference.serviceName.name = new QName(string, (String)object3, (String)object4);
                                }
                            } else {
                                memberSubmissionEndpointReference.serviceName.name = new QName(null, (String)object3);
                            }
                            memberSubmissionEndpointReference.serviceName.attributes = EndpointReferenceUtil.getAttributes(element2);
                            continue;
                        }
                        if (element2.getNamespaceURI().equals(AddressingVersion.W3C.wsdlNsUri) && element2.getLocalName().equals("InterfaceName")) {
                            memberSubmissionEndpointReference.portTypeName = new MemberSubmissionEndpointReference.AttributedQName();
                            object5 = element2.getTextContent();
                            object4 = XmlUtil.getPrefix((String)object5);
                            object3 = XmlUtil.getLocalPart((String)object5);
                            if (object3 == null) continue;
                            if (object4 != null) {
                                string = element2.lookupNamespaceURI((String)object4);
                                if (string != null) {
                                    memberSubmissionEndpointReference.portTypeName.name = new QName(string, (String)object3, (String)object4);
                                }
                            } else {
                                memberSubmissionEndpointReference.portTypeName.name = new QName(null, (String)object3);
                            }
                            memberSubmissionEndpointReference.portTypeName.attributes = EndpointReferenceUtil.getAttributes(element2);
                            continue;
                        }
                        if (element2.getNamespaceURI().equals("http://schemas.xmlsoap.org/wsdl/") && element2.getLocalName().equals(WSDLConstants.QNAME_DEFINITIONS.getLocalPart())) {
                            object5 = DOMUtil.createDom();
                            object4 = object5.createElementNS(MemberSubmissionAddressingConstants.MEX_METADATA.getNamespaceURI(), MemberSubmissionAddressingConstants.MEX_METADATA.getPrefix() + ":" + MemberSubmissionAddressingConstants.MEX_METADATA.getLocalPart());
                            object3 = object5.createElementNS(MemberSubmissionAddressingConstants.MEX_METADATA_SECTION.getNamespaceURI(), MemberSubmissionAddressingConstants.MEX_METADATA_SECTION.getPrefix() + ":" + MemberSubmissionAddressingConstants.MEX_METADATA_SECTION.getLocalPart());
                            object3.setAttribute("Dialect", "http://schemas.xmlsoap.org/wsdl/");
                            object3.appendChild(element2);
                            object4.appendChild((Node)object3);
                            continue;
                        }
                        if (memberSubmissionEndpointReference.elements == null) {
                            memberSubmissionEndpointReference.elements = new ArrayList<Element>();
                        }
                        memberSubmissionEndpointReference.elements.add(element2);
                    }
                    continue;
                }
                if (memberSubmissionEndpointReference.elements == null) {
                    memberSubmissionEndpointReference.elements = new ArrayList<Element>();
                }
                memberSubmissionEndpointReference.elements.add((Element)node2);
                continue;
            }
            if (nodeList.item(i).getNodeType() != 2) continue;
            node2 = nodeList.item(i);
            if (memberSubmissionEndpointReference.attributes != null) continue;
            memberSubmissionEndpointReference.attributes = new HashMap<QName, String>();
            object2 = EndpointReferenceUtil.fixNull(node2.getPrefix());
            String string = EndpointReferenceUtil.fixNull(node2.getNamespaceURI());
            object = node2.getLocalName();
            memberSubmissionEndpointReference.attributes.put(new QName(string, (String)object, (String)object2), node2.getNodeValue());
        }
        return memberSubmissionEndpointReference;
    }

    private static Map<QName, String> getAttributes(Node node) {
        HashMap<QName, String> hashMap = null;
        NamedNodeMap namedNodeMap = node.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            if (hashMap == null) {
                hashMap = new HashMap<QName, String>();
            }
            Node node2 = namedNodeMap.item(i);
            String string = EndpointReferenceUtil.fixNull(node2.getPrefix());
            String string2 = EndpointReferenceUtil.fixNull(node2.getNamespaceURI());
            String string3 = node2.getLocalName();
            if (string.equals("xmlns") || string.length() == 0 && string3.equals("xmlns") || string3.equals("EndpointName")) continue;
            hashMap.put(new QName(string2, string3, string), node2.getNodeValue());
        }
        return hashMap;
    }

    @NotNull
    private static String fixNull(@Nullable String string) {
        if (string == null) {
            return "";
        }
        return string;
    }
}

