/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.transport.http.server;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpsExchange;
import com.sun.xml.internal.ws.resources.HttpserverMessages;
import com.sun.xml.internal.ws.transport.http.HttpAdapter;
import com.sun.xml.internal.ws.transport.http.server.ServerConnectionImpl;
import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.logging.Logger;

final class WSHttpHandler
implements HttpHandler {
    private static final String GET_METHOD = "GET";
    private static final String POST_METHOD = "POST";
    private static final String HEAD_METHOD = "HEAD";
    private static final String PUT_METHOD = "PUT";
    private static final String DELETE_METHOD = "DELETE";
    private static final Logger logger = Logger.getLogger("javax.enterprise.resource.webservices.jaxws.server.http");
    private final HttpAdapter adapter;
    private final Executor executor;

    public WSHttpHandler(@NotNull HttpAdapter httpAdapter, @Nullable Executor executor) {
        assert (httpAdapter != null);
        this.adapter = httpAdapter;
        this.executor = executor;
    }

    public void handle(HttpExchange httpExchange) {
        try {
            logger.fine("Received HTTP request:" + httpExchange.getRequestURI());
            if (this.executor != null) {
                this.executor.execute(new HttpHandlerRunnable(httpExchange));
            } else {
                this.handleExchange(httpExchange);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleExchange(HttpExchange httpExchange) throws IOException {
        ServerConnectionImpl serverConnectionImpl = new ServerConnectionImpl(this.adapter, httpExchange);
        try {
            logger.fine("Received HTTP request:" + httpExchange.getRequestURI());
            String string = httpExchange.getRequestMethod();
            if (string.equals(GET_METHOD)) {
                String string2 = httpExchange.getRequestURI().getQuery();
                logger.fine("Query String for request =" + string2);
                if (this.adapter.isMetadataQuery(string2)) {
                    this.adapter.publishWSDL(serverConnectionImpl, WSHttpHandler.getRequestAddress(httpExchange), httpExchange.getRequestURI().getQuery());
                } else {
                    this.adapter.handle(serverConnectionImpl);
                }
            } else if (string.equals(POST_METHOD) || string.equals(HEAD_METHOD) || string.equals(PUT_METHOD) || string.equals(DELETE_METHOD)) {
                this.adapter.handle(serverConnectionImpl);
            } else {
                logger.warning(HttpserverMessages.UNEXPECTED_HTTP_METHOD(string));
            }
        }
        finally {
            httpExchange.close();
        }
    }

    @NotNull
    static String getRequestAddress(HttpExchange httpExchange) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(httpExchange instanceof HttpsExchange ? "https" : "http");
        stringBuilder.append("://");
        Object object = httpExchange.getRequestHeaders().get("Host");
        if (object != null) {
            stringBuilder.append((String)object.get(0));
        } else {
            stringBuilder.append(httpExchange.getLocalAddress().getHostName());
            stringBuilder.append(":");
            stringBuilder.append(httpExchange.getLocalAddress().getPort());
        }
        stringBuilder.append(httpExchange.getRequestURI().getPath());
        return stringBuilder.toString();
    }

    class HttpHandlerRunnable
    implements Runnable {
        final HttpExchange msg;

        HttpHandlerRunnable(HttpExchange httpExchange) {
            this.msg = httpExchange;
        }

        public void run() {
            try {
                WSHttpHandler.this.handleExchange(this.msg);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }
}

