/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import sun.font.CharToGlyphMapper;
import sun.font.CompositeFont;

public final class CompositeGlyphMapper
extends CharToGlyphMapper {
    public static final int SLOTMASK = -16777216;
    public static final int GLYPHMASK = 0xFFFFFF;
    public static final int NBLOCKS = 216;
    public static final int BLOCKSZ = 256;
    public static final int MAXUNICODE = 55296;
    CompositeFont font;
    CharToGlyphMapper[] slotMappers;
    int[][] glyphMaps;
    private boolean hasExcludes;

    public CompositeGlyphMapper(CompositeFont compositeFont) {
        this.font = compositeFont;
        this.initMapper();
        this.hasExcludes = compositeFont.exclusionRanges != null && compositeFont.maxIndices != null;
    }

    public final int compositeGlyphCode(int n, int n2) {
        return n << 24 | n2 & 0xFFFFFF;
    }

    private final void initMapper() {
        if (this.missingGlyph == -1) {
            if (this.glyphMaps == null) {
                this.glyphMaps = new int[216][];
            }
            this.slotMappers = new CharToGlyphMapper[this.font.numSlots];
            this.missingGlyph = this.font.getSlotFont(0).getMissingGlyphCode();
            this.missingGlyph = this.compositeGlyphCode(0, this.missingGlyph);
        }
    }

    private int getCachedGlyphCode(int n) {
        if (n >= 55296) {
            return -1;
        }
        int[] nArray = this.glyphMaps[n >> 8];
        if (nArray == null) {
            return -1;
        }
        return nArray[n & 0xFF];
    }

    private void setCachedGlyphCode(int n, int n2) {
        if (n >= 55296) {
            return;
        }
        int n3 = n >> 8;
        if (this.glyphMaps[n3] == null) {
            this.glyphMaps[n3] = new int[256];
            for (int i = 0; i < 256; ++i) {
                this.glyphMaps[n3][i] = -1;
            }
        }
        this.glyphMaps[n3][n & 0xFF] = n2;
    }

    private final CharToGlyphMapper getSlotMapper(int n) {
        CharToGlyphMapper charToGlyphMapper = this.slotMappers[n];
        if (charToGlyphMapper == null) {
            this.slotMappers[n] = charToGlyphMapper = this.font.getSlotFont(n).getMapper();
        }
        return charToGlyphMapper;
    }

    private final int convertToGlyph(int n) {
        for (int i = 0; i < this.font.numSlots; ++i) {
            CharToGlyphMapper charToGlyphMapper;
            int n2;
            if (this.hasExcludes && this.font.isExcludedChar(i, n) || (n2 = (charToGlyphMapper = this.getSlotMapper(i)).charToGlyph(n)) == charToGlyphMapper.getMissingGlyphCode()) continue;
            n2 = this.compositeGlyphCode(i, n2);
            this.setCachedGlyphCode(n, n2);
            return n2;
        }
        return this.missingGlyph;
    }

    public int getNumGlyphs() {
        int n = 0;
        for (int i = 0; i < 1; ++i) {
            CharToGlyphMapper charToGlyphMapper = this.slotMappers[i];
            if (charToGlyphMapper == null) {
                this.slotMappers[i] = charToGlyphMapper = this.font.getSlotFont(i).getMapper();
            }
            n += charToGlyphMapper.getNumGlyphs();
        }
        return n;
    }

    public int charToGlyph(int n) {
        int n2 = this.getCachedGlyphCode(n);
        if (n2 == -1) {
            n2 = this.convertToGlyph(n);
        }
        return n2;
    }

    public int charToGlyph(int n, int n2) {
        CharToGlyphMapper charToGlyphMapper;
        int n3;
        if (n2 >= 0 && (n3 = (charToGlyphMapper = this.getSlotMapper(n2)).charToGlyph(n)) != charToGlyphMapper.getMissingGlyphCode()) {
            return this.compositeGlyphCode(n2, n3);
        }
        return this.charToGlyph(n);
    }

    public int charToGlyph(char c) {
        int n = this.getCachedGlyphCode(c);
        if (n == -1) {
            n = this.convertToGlyph(c);
        }
        return n;
    }

    public boolean charsToGlyphsNS(int n, char[] cArray, int[] nArray) {
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3 = cArray[i];
            if (n3 >= 55296 && n3 <= 56319 && i < n - 1 && (n2 = cArray[i + 1]) >= 56320 && n2 <= 57343) {
                n3 = (n3 - 55296) * 1024 + n2 - 56320 + 65536;
                nArray[i + 1] = 65535;
            }
            if ((n2 = (nArray[i] = this.getCachedGlyphCode(n3))) == -1) {
                nArray[i] = this.convertToGlyph(n3);
            }
            if (n3 < 1424) continue;
            if (n3 <= 1535) {
                return true;
            }
            if (n3 >= 1536 && n3 <= 1791) {
                return true;
            }
            if (n3 >= 2304 && n3 <= 3455) {
                return true;
            }
            if (n3 >= 3584 && n3 <= 3711) {
                return true;
            }
            if (n3 >= 6016 && n3 <= 6143) {
                return true;
            }
            if (n3 >= 8204 && n3 <= 8205) {
                return true;
            }
            if (n3 >= 8234 && n3 <= 8238) {
                return true;
            }
            if (n3 >= 8298 && n3 <= 8303) {
                return true;
            }
            if (n3 < 65536) continue;
            ++i;
        }
        return false;
    }

    public void charsToGlyphs(int n, char[] cArray, int[] nArray) {
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3 = cArray[i];
            if (n3 >= 55296 && n3 <= 56319 && i < n - 1 && (n2 = cArray[i + 1]) >= 56320 && n2 <= 57343) {
                nArray[i] = this.getCachedGlyphCode(n3 = (n3 - 55296) * 1024 + n2 - 56320 + 65536);
                int n4 = nArray[i];
                if (n4 == -1) {
                    nArray[i] = this.convertToGlyph(n3);
                }
                nArray[++i] = 65535;
                continue;
            }
            nArray[i] = this.getCachedGlyphCode(n3);
            n2 = nArray[i];
            if (n2 != -1) continue;
            nArray[i] = this.convertToGlyph(n3);
        }
    }

    public void charsToGlyphs(int n, int[] nArray, int[] nArray2) {
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            nArray2[i] = this.getCachedGlyphCode(n2);
            if (nArray2[i] != -1) continue;
            nArray2[i] = this.convertToGlyph(n2);
        }
    }
}

