/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import sun.font.CharToGlyphMapper;
import sun.font.FileFont;
import sun.font.FontManager;
import sun.font.FontStrikeDesc;
import sun.font.FontStrikeDisposer;
import sun.font.NativeStrike;
import sun.font.PhysicalStrike;
import sun.font.StrikeCache;
import sun.font.StrikeMetrics;
import sun.font.TrueTypeFont;

public class FileFontStrike
extends PhysicalStrike {
    static final int INVISIBLE_GLYPHS = 65534;
    private FileFont fileFont;
    private static final int UNINITIALISED = 0;
    private static final int INTARRAY = 1;
    private static final int LONGARRAY = 2;
    private static final int SEGINTARRAY = 3;
    private static final int SEGLONGARRAY = 4;
    private int glyphCacheFormat = 0;
    private static final int SEGSHIFT = 8;
    private static final int SEGSIZE = 256;
    private boolean segmentedCache;
    private int[][] segIntGlyphImages;
    private long[][] segLongGlyphImages;
    private float[] horizontalAdvances;
    private float[][] segHorizontalAdvances;
    ConcurrentHashMap boundsMap;
    SoftReference glyphMetricsMapRef;
    AffineTransform invertDevTx;
    boolean useNatives;
    NativeStrike[] nativeStrikes;
    private static final int SLOTZEROMAX = 0xFFFFFF;

    /*
     * Unable to fully structure code
     */
    FileFontStrike(FileFont var1_1, FontStrikeDesc var2_2) {
        super(var1_1, var2_2);
        this.fileFont = var1_1;
        if (var2_2.style != var1_1.style) {
            if ((var2_2.style & 2) == 2 && (var1_1.style & 2) == 0) {
                this.algoStyle = true;
                this.italic = 0.7f;
            }
            if ((var2_2.style & 1) == 1 && (var1_1.style & 1) == 0) {
                this.algoStyle = true;
                this.boldness = 1.33f;
            }
        }
        var3_3 = new double[4];
        var4_4 = var2_2.glyphTx;
        var4_4.getMatrix(var3_3);
        if (!var2_2.devTx.isIdentity() && var2_2.devTx.getType() != 1) {
            try {
                this.invertDevTx = var2_2.devTx.createInverse();
            }
            catch (NoninvertibleTransformException var5_5) {
                // empty catch block
            }
        }
        if (Double.isNaN(var3_3[0]) || Double.isNaN(var3_3[1]) || Double.isNaN(var3_3[2])) ** GOTO lbl23
        if (Double.isNaN(var3_3[3])) {
lbl23:
            // 2 sources

            this.pScalerContext = FileFontStrike.getNullScalerContext(var1_1.getNullScaler());
        } else {
            this.pScalerContext = this.createScalerContext(var1_1.getScaler(), var3_3, var1_1 instanceof TrueTypeFont, var2_2.aaHint, var2_2.fmHint, this.algoStyle, this.boldness, this.italic);
        }
        this.mapper = var1_1.getMapper();
        var5_6 = this.mapper.getNumGlyphs();
        var6_7 = (float)var3_3[3];
        var7_8 = (int)var6_7;
        var8_9 = (var4_4.getType() & 124) == 0;
        v0 = this.segmentedCache = var5_6 > 2048 || var5_6 > 512 && (var8_9 == false || var6_7 != (float)var7_8 || var7_8 < 6 || var7_8 > 36);
        if (this.pScalerContext == 0L) {
            this.disposer = new FontStrikeDisposer(var1_1, var2_2);
            this.initGlyphCache();
            this.pScalerContext = FileFontStrike.getNullScalerContext(var1_1.getNullScaler());
            FontManager.deRegisterBadFont(var1_1);
            return;
        }
        if (var1_1.checkUseNatives() && var2_2.aaHint == 0 && !this.algoStyle && var3_3[1] == 0.0 && var3_3[2] == 0.0 && var3_3[0] >= 6.0 && var3_3[0] <= 36.0 && var3_3[0] == var3_3[3]) {
            this.useNatives = true;
            var9_10 = var1_1.nativeFonts.length;
            this.nativeStrikes = new NativeStrike[var9_10];
            for (var10_11 = 0; var10_11 < var9_10; ++var10_11) {
                this.nativeStrikes[var10_11] = new NativeStrike(var1_1.nativeFonts[var10_11], var2_2, false);
            }
        }
        this.disposer = new FontStrikeDisposer(var1_1, var2_2, this.pScalerContext);
        v1 = this.getImageWithAdvance = var4_4.getScaleY() <= 48.0;
        if (!this.getImageWithAdvance) {
            if (!this.segmentedCache) {
                this.horizontalAdvances = new float[var5_6];
                for (var9_10 = 0; var9_10 < var5_6; ++var9_10) {
                    this.horizontalAdvances[var9_10] = 3.4028235E38f;
                }
            } else {
                var9_10 = (var5_6 + 256 - 1) / 256;
                this.segHorizontalAdvances = new float[var9_10][];
            }
        }
    }

    static synchronized native long getNullScalerContext(long var0);

    private native long createScalerContext(long var1, double[] var3, boolean var4, int var5, int var6, boolean var7, float var8, float var9);

    public int getNumGlyphs() {
        return this.fileFont.getNumGlyphs();
    }

    long getGlyphImageFromNative(int n) {
        char c = this.fileFont.glyphToCharMap[n];
        for (int i = 0; i < this.nativeStrikes.length; ++i) {
            long l;
            CharToGlyphMapper charToGlyphMapper = this.fileFont.nativeFonts[i].getMapper();
            int n2 = charToGlyphMapper.charToGlyph(c) & 0xFFFF;
            if (n2 == charToGlyphMapper.getMissingGlyphCode() || (l = this.nativeStrikes[i].getGlyphImagePtrNoCache(n2)) == 0L) continue;
            return l;
        }
        return this.fileFont.getGlyphImage(this.pScalerContext, n);
    }

    long getGlyphImagePtr(int n) {
        if (n >= 65534) {
            return StrikeCache.invisibleGlyphPtr;
        }
        long l = this.getCachedGlyphPtr(n);
        if (l != 0L) {
            return l;
        }
        l = this.useNatives ? this.getGlyphImageFromNative(n) : this.fileFont.getGlyphImage(this.pScalerContext, n);
        return this.setCachedGlyphPtr(n, l);
    }

    void getGlyphImagePtrs(int[] nArray, long[] lArray, int n) {
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            if (n2 >= 65534) {
                lArray[i] = StrikeCache.invisibleGlyphPtr;
                continue;
            }
            lArray[i] = this.getCachedGlyphPtr(n2);
            if (lArray[i] != 0L) continue;
            long l = this.useNatives ? this.getGlyphImageFromNative(n2) : this.fileFont.getGlyphImage(this.pScalerContext, n2);
            lArray[i] = this.setCachedGlyphPtr(n2, l);
        }
    }

    int getSlot0GlyphImagePtrs(int[] nArray, long[] lArray, int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3 = nArray[i];
            if (n3 >= 0xFFFFFF) {
                return n2;
            }
            ++n2;
            if (n3 >= 65534) {
                lArray[i] = StrikeCache.invisibleGlyphPtr;
                continue;
            }
            lArray[i] = this.getCachedGlyphPtr(n3);
            if (lArray[i] != 0L) continue;
            long l = this.useNatives ? this.getGlyphImageFromNative(n3) : this.fileFont.getGlyphImage(this.pScalerContext, n3);
            lArray[i] = this.setCachedGlyphPtr(n3, l);
        }
        return n2;
    }

    long getCachedGlyphPtr(int n) {
        switch (this.glyphCacheFormat) {
            case 1: {
                return (long)this.intGlyphImages[n] & 0xFFFFFFFFL;
            }
            case 3: {
                int n2 = n >> 8;
                if (this.segIntGlyphImages[n2] != null) {
                    int n3 = n % 256;
                    return (long)this.segIntGlyphImages[n2][n3] & 0xFFFFFFFFL;
                }
                return 0L;
            }
            case 2: {
                return this.longGlyphImages[n];
            }
            case 4: {
                int n4 = n >> 8;
                if (this.segLongGlyphImages[n4] != null) {
                    int n5 = n % 256;
                    return this.segLongGlyphImages[n4][n5];
                }
                return 0L;
            }
        }
        return 0L;
    }

    private synchronized long setCachedGlyphPtr(int n, long l) {
        switch (this.glyphCacheFormat) {
            case 1: {
                if (this.intGlyphImages[n] == 0) {
                    this.intGlyphImages[n] = (int)l;
                    return l;
                }
                StrikeCache.freeIntPointer((int)l);
                return (long)this.intGlyphImages[n] & 0xFFFFFFFFL;
            }
            case 3: {
                int n2 = n >> 8;
                int n3 = n % 256;
                if (this.segIntGlyphImages[n2] == null) {
                    this.segIntGlyphImages[n2] = new int[256];
                }
                if (this.segIntGlyphImages[n2][n3] == 0) {
                    this.segIntGlyphImages[n2][n3] = (int)l;
                    return l;
                }
                StrikeCache.freeIntPointer((int)l);
                return (long)this.segIntGlyphImages[n2][n3] & 0xFFFFFFFFL;
            }
            case 2: {
                if (this.longGlyphImages[n] == 0L) {
                    this.longGlyphImages[n] = l;
                    return l;
                }
                StrikeCache.freeLongPointer(l);
                return this.longGlyphImages[n];
            }
            case 4: {
                int n4 = n >> 8;
                int n5 = n % 256;
                if (this.segLongGlyphImages[n4] == null) {
                    this.segLongGlyphImages[n4] = new long[256];
                }
                if (this.segLongGlyphImages[n4][n5] == 0L) {
                    this.segLongGlyphImages[n4][n5] = l;
                    return l;
                }
                StrikeCache.freeLongPointer(l);
                return this.segLongGlyphImages[n4][n5];
            }
        }
        this.initGlyphCache();
        return this.setCachedGlyphPtr(n, l);
    }

    private void initGlyphCache() {
        int n = this.mapper.getNumGlyphs();
        if (this.segmentedCache) {
            int n2 = (n + 256 - 1) / 256;
            if (FontManager.longAddresses) {
                this.glyphCacheFormat = 4;
                this.segLongGlyphImages = new long[n2][];
                this.disposer.segLongGlyphImages = this.segLongGlyphImages;
            } else {
                this.glyphCacheFormat = 3;
                this.segIntGlyphImages = new int[n2][];
                this.disposer.segIntGlyphImages = this.segIntGlyphImages;
            }
        } else if (FontManager.longAddresses) {
            this.glyphCacheFormat = 2;
            this.longGlyphImages = new long[n];
            this.disposer.longGlyphImages = this.longGlyphImages;
        } else {
            this.glyphCacheFormat = 1;
            this.intGlyphImages = new int[n];
            this.disposer.intGlyphImages = this.intGlyphImages;
        }
    }

    float getGlyphAdvance(int n) {
        int n2;
        float[] fArray;
        float f;
        if (n >= 65534) {
            return 0.0f;
        }
        if (this.horizontalAdvances != null ? (f = this.horizontalAdvances[n]) != Float.MAX_VALUE : this.segmentedCache && this.segHorizontalAdvances != null && (fArray = this.segHorizontalAdvances[n2 = n >> 8]) != null && (f = fArray[n % 256]) != Float.MAX_VALUE) {
            return f;
        }
        if (this.invertDevTx != null) {
            f = this.getGlyphMetrics((int)n).x;
        } else {
            long l = this.getImageWithAdvance ? this.getGlyphImagePtr(n) : this.getCachedGlyphPtr(n);
            f = l != 0L ? StrikeCache.unsafe.getFloat(l + (long)StrikeCache.xAdvanceOffset) : this.fileFont.getGlyphAdvance(this.pScalerContext, n);
        }
        if (this.horizontalAdvances != null) {
            this.horizontalAdvances[n] = f;
        } else if (this.segmentedCache && this.segHorizontalAdvances != null) {
            n2 = n >> 8;
            int n3 = n % 256;
            if (this.segHorizontalAdvances[n2] == null) {
                this.segHorizontalAdvances[n2] = new float[256];
                for (int i = 0; i < 256; ++i) {
                    this.segHorizontalAdvances[n2][i] = Float.MAX_VALUE;
                }
            }
            this.segHorizontalAdvances[n2][n3] = f;
        }
        return f;
    }

    float getCodePointAdvance(int n) {
        return this.getGlyphAdvance(this.mapper.charToGlyph(n));
    }

    void getGlyphImageBounds(int n, Point2D.Float float_, Rectangle rectangle) {
        int n2;
        long l = this.getGlyphImagePtr(n);
        float f = StrikeCache.unsafe.getFloat(l + (long)StrikeCache.topLeftXOffset);
        float f2 = StrikeCache.unsafe.getFloat(l + (long)StrikeCache.topLeftYOffset);
        rectangle.x = (int)Math.floor(float_.x + f);
        rectangle.y = (int)Math.floor(float_.y + f2);
        rectangle.width = StrikeCache.unsafe.getShort(l + (long)StrikeCache.widthOffset) & 0xFFFF;
        rectangle.height = StrikeCache.unsafe.getShort(l + (long)StrikeCache.heightOffset) & 0xFFFF;
        if ((this.desc.aaHint == 4 || this.desc.aaHint == 5) && f <= -2.0f && (n2 = this.getGlyphImageMinX(l, rectangle.x)) > rectangle.x) {
            ++rectangle.x;
            --rectangle.width;
        }
    }

    private int getGlyphImageMinX(long l, int n) {
        char c = StrikeCache.unsafe.getChar(l + (long)StrikeCache.widthOffset);
        int n2 = StrikeCache.unsafe.getChar(l + (long)StrikeCache.heightOffset);
        char c2 = StrikeCache.unsafe.getChar(l + (long)StrikeCache.rowBytesOffset);
        if (c2 == c) {
            return n;
        }
        long l2 = StrikeCache.nativeAddressSize == 4 ? (long)(0xFFFFFFFF & StrikeCache.unsafe.getInt(l + (long)StrikeCache.pixelDataOffset)) : StrikeCache.unsafe.getLong(l + (long)StrikeCache.pixelDataOffset);
        if (l2 == 0L) {
            return n;
        }
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < 3; ++j) {
                if (StrikeCache.unsafe.getByte(l2 + (long)(i * c2) + (long)j) == 0) continue;
                return n;
            }
        }
        return n + 1;
    }

    StrikeMetrics getFontMetrics() {
        if (this.strikeMetrics == null) {
            this.strikeMetrics = this.fileFont.getFontMetrics(this.pScalerContext);
            if (this.invertDevTx != null) {
                this.strikeMetrics.convertToUserSpace(this.invertDevTx);
            }
        }
        return this.strikeMetrics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Point2D.Float getGlyphMetrics(int n) {
        Point2D.Float float_ = new Point2D.Float();
        if (n >= 65534) {
            return float_;
        }
        long l = this.getImageWithAdvance ? this.getGlyphImagePtr(n) : this.getCachedGlyphPtr(n);
        if (l != 0L) {
            float_ = new Point2D.Float();
            float_.x = StrikeCache.unsafe.getFloat(l + (long)StrikeCache.xAdvanceOffset);
            float_.y = StrikeCache.unsafe.getFloat(l + (long)StrikeCache.yAdvanceOffset);
            if (this.invertDevTx != null) {
                this.invertDevTx.deltaTransform(float_, float_);
            }
        } else {
            FileFontStrike fileFontStrike;
            Integer n2 = new Integer(n);
            Point2D.Float float_2 = null;
            HashMap<Integer, Point2D.Float> hashMap = null;
            if (this.glyphMetricsMapRef != null) {
                hashMap = (HashMap<Integer, Point2D.Float>)this.glyphMetricsMapRef.get();
            }
            if (hashMap != null) {
                fileFontStrike = this;
                synchronized (fileFontStrike) {
                    float_2 = (Point2D.Float)hashMap.get(n2);
                    if (float_2 != null) {
                        float_.x = float_2.x;
                        float_.y = float_2.y;
                        return float_;
                    }
                }
            }
            if (float_2 == null) {
                this.fileFont.getGlyphMetrics(this.pScalerContext, n, float_);
                if (this.invertDevTx != null) {
                    this.invertDevTx.deltaTransform(float_, float_);
                }
                float_2 = new Point2D.Float(float_.x, float_.y);
                fileFontStrike = this;
                synchronized (fileFontStrike) {
                    if (hashMap == null) {
                        hashMap = new HashMap<Integer, Point2D.Float>();
                        this.glyphMetricsMapRef = new SoftReference(hashMap);
                    }
                    hashMap.put(n2, float_2);
                }
            }
        }
        return float_;
    }

    Point2D.Float getCharMetrics(char c) {
        return this.getGlyphMetrics(this.mapper.charToGlyph(c));
    }

    Rectangle2D.Float getGlyphOutlineBounds(int n) {
        Integer n2;
        Rectangle2D.Float float_;
        if (this.boundsMap == null) {
            this.boundsMap = new ConcurrentHashMap();
        }
        if ((float_ = (Rectangle2D.Float)this.boundsMap.get(n2 = new Integer(n))) == null) {
            float_ = this.fileFont.getGlyphOutlineBounds(this.pScalerContext, n);
            this.boundsMap.put(n2, float_);
        }
        return float_;
    }

    public Rectangle2D getOutlineBounds(int n) {
        return this.fileFont.getGlyphOutlineBounds(this.pScalerContext, n);
    }

    GeneralPath getGlyphOutline(int n, float f, float f2) {
        return this.fileFont.getGlyphOutline(this.pScalerContext, n, f, f2);
    }

    GeneralPath getGlyphVectorOutline(int[] nArray, float f, float f2) {
        return this.fileFont.getGlyphVectorOutline(this.pScalerContext, nArray, nArray.length, f, f2);
    }

    protected void adjustPoint(Point2D.Float float_) {
        if (this.invertDevTx != null) {
            this.invertDevTx.deltaTransform(float_, float_);
        }
    }
}

