/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.association;

import com.sun.deploy.association.Action;
import com.sun.deploy.association.Association;
import com.sun.deploy.association.AssociationAlreadyRegisteredException;
import com.sun.deploy.association.AssociationNotRegisteredException;
import com.sun.deploy.association.RegisterFailedException;
import com.sun.deploy.association.utility.AppAssociationReader;
import com.sun.deploy.association.utility.AppAssociationReaderFactory;
import com.sun.deploy.association.utility.AppAssociationWriter;
import com.sun.deploy.association.utility.AppAssociationWriterFactory;
import com.sun.deploy.association.utility.AppUtility;
import java.net.URL;
import java.util.Iterator;
import java.util.List;

public class AssociationService {
    private AppAssociationReader appAssocReader = AppAssociationReaderFactory.newInstance();
    private AppAssociationWriter appAssocWriter = AppAssociationWriterFactory.newInstance();

    public Association getMimeTypeAssociation(String string) {
        Iterator iterator;
        if (string == null) {
            throw new IllegalArgumentException("The specified mime type is null");
        }
        if (!this.appAssocReader.isMimeTypeExist(string)) {
            return null;
        }
        Association association = new Association();
        List list = this.appAssocReader.getFileExtListByMimeType(string);
        String string2 = this.appAssocReader.getIconFileNameByMimeType(string);
        String string3 = this.appAssocReader.getDescriptionByMimeType(string);
        List list2 = this.appAssocReader.getActionListByMimeType(string);
        association.setMimeType(string);
        if (list != null && (iterator = list.iterator()) != null) {
            while (iterator.hasNext()) {
                association.addFileExtension((String)iterator.next());
            }
        }
        if (string2 != null) {
            association.setIconFileName(string2);
        }
        if (string3 != null) {
            association.setDescription(string3);
        }
        if (list2 != null && (iterator = list2.iterator()) != null) {
            while (iterator.hasNext()) {
                association.addAction((Action)iterator.next());
            }
        }
        return association;
    }

    public Association getFileExtensionAssociation(String string) {
        Iterator iterator;
        if (string == null) {
            throw new IllegalArgumentException("The specified file extension is null");
        }
        if (!this.appAssocReader.isFileExtExist(string = AppUtility.addDotToFileExtension(string))) {
            return null;
        }
        Association association = new Association();
        String string2 = this.appAssocReader.getMimeTypeByFileExt(string);
        String string3 = this.appAssocReader.getIconFileNameByFileExt(string);
        String string4 = this.appAssocReader.getDescriptionByFileExt(string);
        List list = this.appAssocReader.getActionListByFileExt(string);
        association.addFileExtension(string);
        if (string3 != null) {
            association.setIconFileName(string3);
        }
        if (string2 != null) {
            association.setMimeType(string2);
        }
        if (string4 != null) {
            association.setDescription(string4);
        }
        if (list != null && (iterator = list.iterator()) != null) {
            while (iterator.hasNext()) {
                association.addAction((Action)iterator.next());
            }
        }
        return association;
    }

    public Association getAssociationByContent(URL uRL) {
        String string;
        if (uRL == null) {
            throw new IllegalArgumentException("The specified URL is null");
        }
        Association association = null;
        String string2 = this.appAssocReader.getMimeTypeByURL(uRL);
        if (string2 != null) {
            association = this.getMimeTypeAssociation(string2);
        }
        if (association == null && (string = AppUtility.getFileExtensionByURL(uRL)) != null) {
            association = this.getFileExtensionAssociation(string);
        }
        return association;
    }

    public void registerUserAssociation(Association association) throws AssociationAlreadyRegisteredException, RegisterFailedException {
        if (association == null) {
            throw new IllegalArgumentException("The specified association is null");
        }
        this.appAssocWriter.checkAssociationValidForRegistration(association);
        if (this.appAssocWriter.isAssociationExist(association, 1)) {
            throw new AssociationAlreadyRegisteredException("Assocation already exists!");
        }
        this.appAssocWriter.registerAssociation(association, 1);
    }

    public void unregisterUserAssociation(Association association) throws AssociationNotRegisteredException, RegisterFailedException {
        if (association == null) {
            throw new IllegalArgumentException("The specified association is null");
        }
        this.appAssocWriter.checkAssociationValidForUnregistration(association);
        if (!this.appAssocWriter.isAssociationExist(association, 1)) {
            throw new AssociationNotRegisteredException("Assocation not exists!");
        }
        this.appAssocWriter.unregisterAssociation(association, 1);
    }

    public void registerSystemAssociation(Association association) throws AssociationAlreadyRegisteredException, RegisterFailedException {
        if (association == null) {
            throw new IllegalArgumentException("The specified association is null");
        }
        this.appAssocWriter.checkAssociationValidForRegistration(association);
        if (this.appAssocWriter.isAssociationExist(association, 2)) {
            throw new AssociationAlreadyRegisteredException("Assocation already exists!");
        }
        this.appAssocWriter.registerAssociation(association, 2);
    }

    public void unregisterSystemAssociation(Association association) throws AssociationNotRegisteredException, RegisterFailedException {
        if (association == null) {
            throw new IllegalArgumentException("The specified association is null");
        }
        this.appAssocWriter.checkAssociationValidForUnregistration(association);
        if (!this.appAssocWriter.isAssociationExist(association, 2)) {
            throw new AssociationNotRegisteredException("Assocation not existed!");
        }
        this.appAssocWriter.unregisterAssociation(association, 2);
    }
}

