/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.util;

import com.sun.deploy.cache.MemoryCache;
import com.sun.deploy.net.proxy.DynamicProxyManager;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.CertificateHostnameVerifier;
import com.sun.deploy.security.TrustDecider;
import com.sun.deploy.security.X509DeployTrustManager;
import com.sun.deploy.services.ServiceManager;
import com.sun.deploy.util.ConsoleController;
import com.sun.deploy.util.ConsoleHelper;
import com.sun.deploy.util.LoggerTraceListener;
import com.sun.deploy.util.Trace;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.Policy;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.plugin.ClassLoaderInfo;
import sun.plugin.WJcovUtil;
import sun.plugin.services.BrowserService;
import sun.plugin.util.PluginSysUtil;
import sun.plugin.util.UserProfile;
import sun.security.action.GetPropertyAction;

public class PluginConsoleController
implements ConsoleController {
    private boolean onWindows = false;
    private boolean isMozilla = false;
    private boolean iconifiedOnClose = false;
    private Logger logger = null;

    public PluginConsoleController() {
        try {
            String string;
            String string2 = AccessController.doPrivileged(new GetPropertyAction("os.name"));
            if (string2.indexOf("Windows") != -1) {
                this.onWindows = true;
            }
            if ((string = AccessController.doPrivileged(new GetPropertyAction("mozilla.workaround", "false"))) != null && string.equalsIgnoreCase("true")) {
                this.isMozilla = true;
            }
            BrowserService browserService = (BrowserService)ServiceManager.getService();
            this.iconifiedOnClose = browserService.isConsoleIconifiedOnClose();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean isIconifiedOnClose() {
        return this.iconifiedOnClose;
    }

    public boolean isDoubleBuffered() {
        return this.onWindows || !this.isMozilla;
    }

    public boolean isDumpStackSupported() {
        return true;
    }

    public String dumpAllStacks() {
        return ConsoleHelper.dumpAllStacks();
    }

    public ThreadGroup getMainThreadGroup() {
        return PluginSysUtil.getPluginThreadGroup().getParent();
    }

    public boolean isSecurityPolicyReloadSupported() {
        return true;
    }

    public void reloadSecurityPolicy() {
        Policy policy = Policy.getPolicy();
        policy.refresh();
    }

    public boolean isProxyConfigReloadSupported() {
        return true;
    }

    public void reloadProxyConfig() {
        DynamicProxyManager.reset();
    }

    public boolean isDumpClassLoaderSupported() {
        return true;
    }

    public String dumpClassLoaders() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        ClassLoaderInfo.dumpClassLoaderCache(printStream);
        return new String(byteArrayOutputStream.toByteArray());
    }

    public boolean isClearClassLoaderSupported() {
        return true;
    }

    public void clearClassLoaders() {
        MemoryCache.clearLoadedResources();
        ClassLoaderInfo.clearClassLoaderCache();
        TrustDecider.reset();
        X509DeployTrustManager.reset();
        CertificateHostnameVerifier.reset();
    }

    public boolean isLoggingSupported() {
        return true;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public boolean toggleLogging() {
        Serializable serializable;
        if (this.logger == null) {
            serializable = new File(UserProfile.getLogDirectory());
            File file = Trace.createTempFile((String)"plugin", (String)".log", (File)serializable);
            LoggerTraceListener loggerTraceListener = new LoggerTraceListener("sun.plugin", file.getPath());
            this.logger = loggerTraceListener.getLogger();
        }
        serializable = (serializable = this.logger.getLevel()) == Level.OFF ? Level.ALL : Level.OFF;
        this.logger.setLevel((Level)serializable);
        return serializable == Level.ALL;
    }

    public boolean isJCovSupported() {
        boolean bl = false;
        if (this.onWindows) {
            String string = System.getProperty("javaplugin.vm.options");
            bl = string.indexOf("-Xrunjcov") != -1;
        }
        return bl;
    }

    public boolean dumpJCovData() {
        return WJcovUtil.dumpJcovData();
    }

    public String getProductName() {
        return ResourceManager.getString((String)"product.javapi.name", (String)System.getProperty("java.version"));
    }

    public void invokeLater(Runnable runnable) {
        PluginSysUtil.invokeLater(runnable);
    }
}

