/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.debugger.remote;

import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.Debugger;
import sun.jvm.hotspot.debugger.DebuggerException;
import sun.jvm.hotspot.debugger.MachineDescription;
import sun.jvm.hotspot.debugger.ReadResult;
import sun.jvm.hotspot.debugger.ThreadContext;
import sun.jvm.hotspot.debugger.ThreadProxy;
import sun.jvm.hotspot.debugger.remote.RemoteDebugger;

public class RemoteDebuggerServer
extends UnicastRemoteObject
implements RemoteDebugger {
    private transient Debugger debugger;

    public RemoteDebuggerServer() throws RemoteException {
    }

    public RemoteDebuggerServer(Debugger debugger) throws RemoteException {
        this.debugger = debugger;
    }

    public String getOS() throws RemoteException {
        return this.debugger.getOS();
    }

    public String getCPU() throws RemoteException {
        return this.debugger.getCPU();
    }

    public MachineDescription getMachineDescription() throws RemoteException {
        return this.debugger.getMachineDescription();
    }

    public long lookupInProcess(String objectName, String symbol) throws RemoteException {
        Address addr = this.debugger.lookup(objectName, symbol);
        return addr == null ? 0L : this.debugger.getAddressValue(addr);
    }

    public ReadResult readBytesFromProcess(long address, long numBytes) throws RemoteException {
        return this.debugger.readBytesFromProcess(address, numBytes);
    }

    public boolean hasConsole() throws RemoteException {
        return this.debugger.hasConsole();
    }

    public String getConsolePrompt() throws RemoteException {
        return this.debugger.getConsolePrompt();
    }

    public String consoleExecuteCommand(String cmd) throws RemoteException {
        return this.debugger.consoleExecuteCommand(cmd);
    }

    public long getJBooleanSize() throws RemoteException {
        return this.debugger.getJBooleanSize();
    }

    public long getJByteSize() throws RemoteException {
        return this.debugger.getJByteSize();
    }

    public long getJCharSize() throws RemoteException {
        return this.debugger.getJCharSize();
    }

    public long getJDoubleSize() throws RemoteException {
        return this.debugger.getJDoubleSize();
    }

    public long getJFloatSize() throws RemoteException {
        return this.debugger.getJFloatSize();
    }

    public long getJIntSize() throws RemoteException {
        return this.debugger.getJIntSize();
    }

    public long getJLongSize() throws RemoteException {
        return this.debugger.getJLongSize();
    }

    public long getJShortSize() throws RemoteException {
        return this.debugger.getJShortSize();
    }

    public boolean areThreadsEqual(long addrOrId1, boolean isAddress1, long addrOrId2, boolean isAddress2) throws RemoteException {
        ThreadProxy t1 = this.getThreadProxy(addrOrId1, isAddress1);
        ThreadProxy t2 = this.getThreadProxy(addrOrId2, isAddress2);
        return t1.equals(t2);
    }

    public int getThreadHashCode(long addrOrId, boolean isAddress) throws RemoteException {
        ThreadProxy t = this.getThreadProxy(addrOrId, isAddress);
        return t.hashCode();
    }

    public long[] getThreadIntegerRegisterSet(long addrOrId, boolean isAddress) throws RemoteException {
        ThreadProxy t = this.getThreadProxy(addrOrId, isAddress);
        ThreadContext tc = t.getContext();
        long[] regs = new long[tc.getNumRegisters()];
        for (int r = 0; r < regs.length; ++r) {
            regs[r] = tc.getRegister(r);
        }
        return regs;
    }

    private ThreadProxy getThreadProxy(long addrOrId, boolean isAddress) throws DebuggerException {
        if (isAddress) {
            Address addr = this.debugger.parseAddress("0x" + Long.toHexString(addrOrId));
            return this.debugger.getThreadForIdentifierAddress(addr);
        }
        return this.debugger.getThreadForThreadId(addrOrId);
    }
}

