/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.interpreter;

import sun.jvm.hotspot.interpreter.Bytecode;
import sun.jvm.hotspot.interpreter.BytecodeStream;
import sun.jvm.hotspot.oops.Method;
import sun.jvm.hotspot.utilities.Assert;

public class BytecodeNewArray
extends Bytecode {
    BytecodeNewArray(Method method, int bci) {
        super(method, bci);
    }

    public int getType() {
        return this.javaByteAt(1);
    }

    public void verify() {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(this.isValid(), "check newarray");
        }
    }

    public boolean isValid() {
        boolean result;
        boolean bl = result = this.javaCode() == 188;
        if (!result) {
            return false;
        }
        switch (this.getType()) {
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public String getTypeName() {
        String result;
        switch (this.getType()) {
            case 4: {
                result = "boolean";
                break;
            }
            case 5: {
                result = "char";
                break;
            }
            case 6: {
                result = "float";
                break;
            }
            case 7: {
                result = "double";
                break;
            }
            case 8: {
                result = "byte";
                break;
            }
            case 9: {
                result = "short";
                break;
            }
            case 10: {
                result = "int";
                break;
            }
            case 11: {
                result = "long";
                break;
            }
            default: {
                result = "<invalid>";
            }
        }
        return result;
    }

    public static BytecodeNewArray at(Method method, int bci) {
        BytecodeNewArray b = new BytecodeNewArray(method, bci);
        if (Assert.ASSERTS_ENABLED) {
            b.verify();
        }
        return b;
    }

    public static BytecodeNewArray atCheck(Method method, int bci) {
        BytecodeNewArray b = new BytecodeNewArray(method, bci);
        return b.isValid() ? b : null;
    }

    public static BytecodeNewArray at(BytecodeStream bcs) {
        return new BytecodeNewArray(bcs.method(), bcs.bci());
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("newarray");
        buf.append(" ");
        buf.append(this.getTypeName());
        return buf.toString();
    }
}

