/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.memory;

import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.gc_interface.CollectedHeap;
import sun.jvm.hotspot.gc_interface.CollectedHeapName;
import sun.jvm.hotspot.memory.CMSPermGen;
import sun.jvm.hotspot.memory.CompactingPermGen;
import sun.jvm.hotspot.memory.Generation;
import sun.jvm.hotspot.memory.PermGen;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VirtualConstructor;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;

public abstract class SharedHeap
extends CollectedHeap {
    private static AddressField permGenField;
    private static VirtualConstructor ctor;

    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("SharedHeap");
        permGenField = type.getAddressField("_perm_gen");
        ctor = new VirtualConstructor(db);
        ctor.addMapping("CompactingPermGen", CompactingPermGen.class);
        ctor.addMapping("CMSPermGen", CMSPermGen.class);
    }

    public SharedHeap(Address addr) {
        super(addr);
    }

    public PermGen perm() {
        return (PermGen)ctor.instantiateWrapperFor(permGenField.getValue(this.addr));
    }

    public CollectedHeapName kind() {
        return CollectedHeapName.SHARED_HEAP;
    }

    public Generation permGen() {
        return this.perm().asGen();
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            public void update(Observable o, Object data) {
                SharedHeap.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

