/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.oops;

import java.io.PrintStream;
import sun.jvm.hotspot.oops.AccessFlags;
import sun.jvm.hotspot.oops.ConstantPool;
import sun.jvm.hotspot.oops.FieldIdentifier;
import sun.jvm.hotspot.oops.FieldType;
import sun.jvm.hotspot.oops.InstanceKlass;
import sun.jvm.hotspot.oops.NamedFieldIdentifier;
import sun.jvm.hotspot.oops.Symbol;
import sun.jvm.hotspot.oops.TypeArray;
import sun.jvm.hotspot.runtime.VM;

public class Field {
    private long offset;
    private FieldIdentifier id;
    private boolean isVMField;
    private InstanceKlass holder;
    private FieldType fieldType;
    private Symbol signature;
    private Symbol genericSignature;
    private AccessFlags accessFlags;
    private int fieldArrayIndex;

    Field(FieldIdentifier id, long offset, boolean isVMField) {
        this.offset = offset;
        this.id = id;
        this.isVMField = isVMField;
    }

    Field(InstanceKlass holder, int fieldArrayIndex) {
        this.holder = holder;
        this.fieldArrayIndex = fieldArrayIndex;
        ConstantPool cp = holder.getConstants();
        TypeArray fields = holder.getFields();
        short access = fields.getShortAt(fieldArrayIndex + InstanceKlass.ACCESS_FLAGS_OFFSET);
        short nameIndex = fields.getShortAt(fieldArrayIndex + InstanceKlass.NAME_INDEX_OFFSET);
        short signatureIndex = fields.getShortAt(fieldArrayIndex + InstanceKlass.SIGNATURE_INDEX_OFFSET);
        this.offset = VM.getVM().buildIntFromShorts(fields.getShortAt(fieldArrayIndex + InstanceKlass.LOW_OFFSET), fields.getShortAt(fieldArrayIndex + InstanceKlass.HIGH_OFFSET));
        short genericSignatureIndex = fields.getShortAt(fieldArrayIndex + InstanceKlass.GENERIC_SIGNATURE_INDEX_OFFSET);
        Symbol name = cp.getSymbolAt(nameIndex);
        this.id = new NamedFieldIdentifier(name.asString());
        this.signature = cp.getSymbolAt(signatureIndex);
        this.genericSignature = genericSignatureIndex != 0 ? cp.getSymbolAt(genericSignatureIndex) : null;
        this.fieldType = new FieldType(this.signature);
        this.accessFlags = new AccessFlags(access);
    }

    public long getOffset() {
        return this.offset;
    }

    public FieldIdentifier getID() {
        return this.id;
    }

    public boolean isVMField() {
        return this.isVMField;
    }

    public boolean isNamedField() {
        return this.id instanceof NamedFieldIdentifier;
    }

    public void printOn(PrintStream tty) {
        this.getID().printOn(tty);
        tty.print(" {" + this.getOffset() + "} :");
    }

    public InstanceKlass getFieldHolder() {
        return this.holder;
    }

    public int getFieldArrayIndex() {
        return this.fieldArrayIndex;
    }

    public long getAccessFlags() {
        return this.accessFlags.getValue();
    }

    public AccessFlags getAccessFlagsObj() {
        return this.accessFlags;
    }

    public FieldType getFieldType() {
        return this.fieldType;
    }

    public Symbol getSignature() {
        return this.signature;
    }

    public Symbol getGenericSignature() {
        return this.genericSignature;
    }

    public boolean isPublic() {
        return this.accessFlags.isPublic();
    }

    public boolean isPrivate() {
        return this.accessFlags.isPrivate();
    }

    public boolean isProtected() {
        return this.accessFlags.isProtected();
    }

    public boolean isPackagePrivate() {
        return !this.isPublic() && !this.isPrivate() && !this.isProtected();
    }

    public boolean isStatic() {
        return this.accessFlags.isStatic();
    }

    public boolean isFinal() {
        return this.accessFlags.isFinal();
    }

    public boolean isVolatile() {
        return this.accessFlags.isVolatile();
    }

    public boolean isTransient() {
        return this.accessFlags.isTransient();
    }

    public boolean isSynthetic() {
        return this.accessFlags.isSynthetic();
    }

    public boolean isEnumConstant() {
        return this.accessFlags.isEnum();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Field)) {
            return false;
        }
        Field other = (Field)obj;
        return this.getFieldHolder().equals(other.getFieldHolder()) && this.getID().equals(other.getID());
    }

    public int hashCode() {
        return this.getFieldHolder().hashCode() ^ this.getID().hashCode();
    }
}

