/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import sun.tools.jconsole.resources.JConsoleResources;

public final class Resources {
    private static final Object lock = new Object();
    private static JConsoleResources resources = null;

    private Resources() {
        throw new AssertionError();
    }

    public static String getText(String string, Object ... objectArray) {
        String string2 = Resources.getString(string);
        if (string2 == null) {
            string2 = "missing resource key: key = \"" + string + "\", " + "arguments = \"{0}\", \"{1}\", \"{2}\"";
        }
        return Resources.formatMessage(string2, objectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String formatMessage(String string, Object ... objectArray) {
        String string2 = null;
        Object object = lock;
        synchronized (object) {
            string2 = MessageFormat.format(string, objectArray);
        }
        return string2;
    }

    public static int getMnemonicInt(String string) {
        int n = 0;
        if (resources != null) {
            Object object = resources.getObject(string + ".mnemonic");
            if (object instanceof Character) {
                n = ((Character)object).charValue();
                if (n >= 97 && n <= 122) {
                    n -= 32;
                }
            } else if (object instanceof Integer) {
                n = (Integer)object;
            }
        }
        return n;
    }

    private static String getString(String string) {
        if (resources != null) {
            try {
                return resources.getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                return null;
            }
        }
        return "missing resource bundle: key = \"" + string + "\", " + "arguments = \"{0}\", \"{1}\", \"{2}\"";
    }

    static {
        try {
            resources = (JConsoleResources)ResourceBundle.getBundle("sun.tools.jconsole.resources.JConsoleResources");
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }
}

