/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.locks;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.locks.CompatibilitySpace;
import org.apache.derby.iapi.services.locks.Latch;
import org.apache.derby.iapi.services.locks.Lockable;
import org.apache.derby.impl.services.locks.AbstractPool;
import org.apache.derby.impl.services.locks.ActiveLock;
import org.apache.derby.impl.services.locks.Control;
import org.apache.derby.impl.services.locks.Deadlock;
import org.apache.derby.impl.services.locks.Lock;
import org.apache.derby.impl.services.locks.LockControl;
import org.apache.derby.impl.services.locks.LockTable;
import org.apache.derby.impl.services.locks.Timeout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ConcurrentLockSet
implements LockTable {
    private final AbstractPool factory;
    private final ConcurrentHashMap<Lockable, Entry> locks;
    private ArrayList<Entry> seenByDeadlockDetection;
    private int deadlockTimeout = 20000;
    private int waitTimeout = 60000;
    private boolean deadlockTrace;
    private final AtomicInteger blockCount;

    ConcurrentLockSet(AbstractPool abstractPool) {
        this.factory = abstractPool;
        this.blockCount = new AtomicInteger();
        this.locks = new ConcurrentHashMap();
    }

    private Entry getEntry(Lockable lockable) {
        Entry entry = this.locks.get(lockable);
        while (true) {
            Entry entry2;
            if (entry != null) {
                entry.lock();
                if (entry.control != null) {
                    return entry;
                }
            } else {
                entry = new Entry();
                entry.lock();
            }
            if ((entry2 = this.locks.putIfAbsent(lockable, entry)) == null) {
                return entry;
            }
            entry.unlock();
            entry = entry2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] checkDeadlock(Entry entry, ActiveLock activeLock, byte by) {
        LockControl lockControl = (LockControl)entry.control;
        entry.enterDeadlockDetection();
        Class<Deadlock> clazz = Deadlock.class;
        synchronized (Deadlock.class) {
            Object[] objectArray;
            try {
                objectArray = Deadlock.look(this.factory, this, lockControl, activeLock, by);
            }
            catch (Throwable throwable) {
                for (Entry entry2 : this.seenByDeadlockDetection) {
                    entry2.unlock();
                }
                this.seenByDeadlockDetection = null;
                entry.exitDeadlockDetection();
                throw throwable;
            }
            for (Entry entry3 : this.seenByDeadlockDetection) {
                entry3.unlock();
            }
            this.seenByDeadlockDetection = null;
            entry.exitDeadlockDetection();
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return objectArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Lock lockObject(CompatibilitySpace compatibilitySpace, Lockable lockable, Object object, int n) throws StandardException {
        int n2;
        Lock lock;
        LockControl lockControl;
        Object var7_5 = null;
        Entry entry = this.getEntry(lockable);
        try {
            Control control = entry.control;
            if (control == null) {
                Lock lock2 = new Lock(compatibilitySpace, lockable, object);
                lock2.grant();
                entry.control = lock2;
                Lock lock3 = lock2;
                return lock3;
            }
            lockControl = control.getLockControl();
            if (lockControl != control) {
                entry.control = lockControl;
            }
            if ((lock = lockControl.addLock(this, compatibilitySpace, object)).getCount() != 0) {
                Lock lock4 = lock;
                return lock4;
            }
            if (n == 0) {
                lockControl.giveUpWait(lock, this);
                Lock lock5 = null;
                return lock5;
            }
        }
        finally {
            entry.unlock();
        }
        boolean bl = false;
        if (n == -1) {
            bl = true;
            n2 = this.deadlockTimeout;
            if (n2 == -1) {
                n2 = 20000;
            }
        } else {
            if (n == -2) {
                n = n2 = this.waitTimeout;
            } else {
                n2 = n;
            }
            if (this.deadlockTimeout >= 0) {
                if (n2 < 0) {
                    bl = true;
                    n2 = this.deadlockTimeout;
                } else if (this.deadlockTimeout < n2) {
                    bl = true;
                    n2 = this.deadlockTimeout;
                    n -= this.deadlockTimeout;
                }
            }
        }
        ActiveLock activeLock = (ActiveLock)lock;
        lock = null;
        int n3 = 0;
        long l = 0L;
        while (true) {
            long l2;
            byte by = activeLock.waitForGrant(n2);
            ActiveLock activeLock2 = null;
            Object[] objectArray = null;
            try {
                boolean bl2;
                Enumeration enumeration = null;
                l2 = 0L;
                entry.lock();
                try {
                    if (lockControl.isGrantable(lockControl.firstWaiter() == activeLock, compatibilitySpace, object)) {
                        lockControl.grant(activeLock);
                        activeLock2 = lockControl.getNextWaiter(activeLock, true, this);
                        ActiveLock activeLock3 = activeLock;
                        return activeLock3;
                    }
                    activeLock.clearPotentiallyGranted();
                    boolean bl3 = bl2 = by != 1;
                    if (by == 0 && bl || by == 2) {
                        objectArray = this.checkDeadlock(entry, activeLock, by);
                        if (objectArray == null) {
                            bl = false;
                            n2 = n;
                            l = 0L;
                            bl2 = false;
                        } else {
                            bl2 = true;
                        }
                    }
                    activeLock2 = lockControl.getNextWaiter(activeLock, bl2, this);
                }
                finally {
                    entry.unlock();
                }
                if (bl2) {
                    if (this.deadlockTrace && objectArray == null) {
                        l2 = System.currentTimeMillis();
                        enumeration = this.factory.makeVirtualLockTable();
                    }
                    if (objectArray == null) {
                        if (this.deadlockTrace) {
                            throw Timeout.buildException(activeLock, enumeration, l2);
                        }
                        StandardException standardException = StandardException.newException("40XL1");
                        throw standardException;
                    }
                    throw Deadlock.buildException(this.factory, objectArray);
                }
            }
            finally {
                if (activeLock2 != null) {
                    activeLock2.wakeUp((byte)1);
                    activeLock2 = null;
                }
            }
            if (n2 == -1) continue;
            if (by != 0) {
                ++n3;
            }
            if (n3 <= 5) continue;
            long l3 = System.currentTimeMillis();
            if (l != 0L) {
                l2 = l3 - l;
                n2 = (int)((long)n2 - l2);
            }
            l = l3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlock(Latch latch, int n) {
        Entry entry = this.locks.get(latch.getLockable());
        entry.lock();
        try {
            this.unlock(entry, latch, n);
        }
        finally {
            entry.unlock();
        }
    }

    private void unlock(Entry entry, Latch latch, int n) {
        boolean bl = false;
        ActiveLock activeLock = null;
        Control control = entry.control;
        bl = control.unlock(latch, n);
        latch = null;
        boolean bl2 = true;
        if (bl && (activeLock = control.firstWaiter()) != null) {
            bl2 = false;
            if (!activeLock.setPotentiallyGranted()) {
                activeLock = null;
            }
        }
        if (bl2) {
            if (control.isEmpty()) {
                this.locks.remove(control.getLockable());
                entry.control = null;
            }
            return;
        }
        if (bl && activeLock != null) {
            activeLock.wakeUp((byte)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Lock unlockReference(CompatibilitySpace compatibilitySpace, Lockable lockable, Object object, Map map) {
        Entry entry = this.locks.get(lockable);
        if (entry == null) {
            return null;
        }
        entry.lock();
        try {
            Control control = entry.control;
            if (control == null) {
                Lock lock = null;
                return lock;
            }
            Lock lock = control.getLock(compatibilitySpace, object);
            if (lock == null) {
                Lock lock2 = null;
                return lock2;
            }
            Lock lock3 = (Lock)map.remove(lock);
            if (lock3 != null) {
                this.unlock(entry, lock3, 1);
            }
            Lock lock4 = lock3;
            return lock4;
        }
        finally {
            entry.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean zeroDurationLockObject(CompatibilitySpace compatibilitySpace, Lockable lockable, Object object, int n) throws StandardException {
        Control control;
        Entry entry = this.locks.get(lockable);
        if (entry == null) {
            return true;
        }
        entry.lock();
        try {
            control = entry.control;
            if (control == null) {
                boolean bl = true;
                return bl;
            }
            if (control.isGrantable(true, compatibilitySpace, object)) {
                boolean bl = true;
                return bl;
            }
            if (n == 0) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            entry.unlock();
        }
        control = this.lockObject(compatibilitySpace, lockable, object, n);
        this.unlock((Latch)((Object)control), 1);
        return true;
    }

    @Override
    public void setDeadlockTimeout(int n) {
        this.deadlockTimeout = n;
    }

    @Override
    public void setWaitTimeout(int n) {
        this.waitTimeout = n;
    }

    @Override
    public void setDeadlockTrace(boolean bl) {
        this.deadlockTrace = bl;
    }

    private String toDebugString() {
        return null;
    }

    @Override
    public void addWaiters(Map map) {
        this.seenByDeadlockDetection = new ArrayList(this.locks.size());
        for (Entry entry : this.locks.values()) {
            this.seenByDeadlockDetection.add(entry);
            entry.lockForDeadlockDetection();
            if (entry.control == null) continue;
            entry.control.addWaiters(map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Lockable, Control> shallowClone() {
        HashMap<Lockable, Control> hashMap = new HashMap<Lockable, Control>();
        for (Entry entry : this.locks.values()) {
            entry.lock();
            try {
                Control control = entry.control;
                if (control == null) continue;
                hashMap.put(control.getLockable(), control.shallowClone());
            }
            finally {
                entry.unlock();
            }
        }
        return hashMap;
    }

    @Override
    public void oneMoreWaiter() {
        this.blockCount.incrementAndGet();
    }

    @Override
    public void oneLessWaiter() {
        this.blockCount.decrementAndGet();
    }

    @Override
    public boolean anyoneBlocked() {
        int n = this.blockCount.get();
        return n != 0;
    }

    private static final class Entry {
        Control control;
        private final ReentrantLock mutex = new ReentrantLock();
        private Condition deadlockDetection;

        private Entry() {
        }

        void lock() {
            this.mutex.lock();
            while (this.deadlockDetection != null) {
                this.deadlockDetection.awaitUninterruptibly();
            }
        }

        void unlock() {
            this.mutex.unlock();
        }

        void lockForDeadlockDetection() {
            this.mutex.lock();
        }

        void enterDeadlockDetection() {
            this.deadlockDetection = this.mutex.newCondition();
            this.mutex.unlock();
        }

        void exitDeadlockDetection() {
            this.mutex.lock();
            this.deadlockDetection.signalAll();
            this.deadlockDetection = null;
        }
    }
}

