/*
 * xconvers - GTK+ convers client for amateur radio
 * Copyright (C) 2000-2001 Joop Stakenborg <pa4tu@amsat.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * preferences.c - private functions for saving and recalling xconvers preferences.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include <gtk/gtk.h>
#include <stdio.h>
#include <sys/stat.h>
#include "support.h"
#include "preferences.h"
#include "types.h"
#include "color.h"

extern GtkWidget *mainwindow;
extern gchar *preferencesdir;
extern preferencestype preferences;

/*
 * Check if ~/.xconvers directory exists. If not: create it and exit if errors.
 */
 
void dircheck()
{
  GString *packagedir;
  struct stat statdir;

  packagedir = g_string_new("/.");
  g_string_append(packagedir, PACKAGE);
  preferencesdir = g_strconcat(g_get_home_dir(), packagedir->str, NULL);
  if (stat(preferencesdir, &statdir) == -1)
  {
    if (mkdir(preferencesdir, S_IRUSR | S_IWUSR | S_IXUSR) == -1)
      g_error("Creating ~%s directory.", packagedir->str);
  }
  else if (!S_ISDIR(statdir.st_mode)) g_error("~%s is not a directory.",
    packagedir->str);
}

/*
 * Lookup settings in ~/.xconvers/preferences. I have put in the many '{}' for
 * clarity. The default for menu, statusbar and scrollbar is 'on'.
 */

void loadpreferences(void)
{
  gchar *preferencesfile, label[100], value[100];
  FILE *fp;

  preferences.logging = FALSE;
  preferences.autologin = FALSE;
  preferences.menu = TRUE;
  preferences.statusbar = TRUE;
  preferences.scrollbar = TRUE;
  preferences.font = g_string_new("fixed");
  gdk_color_parse("grey1", &preferences.background);
  preferencesfile = g_strconcat(preferencesdir, "/preferences", NULL);
  fp = fopen(preferencesfile, "r");
  if (fp == NULL) return;
  while(!feof(fp))
  {
    if (fscanf(fp, "%s %s", label, value) == EOF) break;
    if (!g_strcasecmp(label, "logging"))
    {
      if (!g_strcasecmp(value,"on"))
        preferences.logging = TRUE;
    }
    else
    {
      if (!g_strcasecmp(label, "autologin"))
      {
        if (!g_strcasecmp(value,"on"))
          preferences.autologin = TRUE;
      }
      else
      {
        if (!g_strcasecmp(label, "name"))
          preferences.name = g_string_new(value);
        else
        {
          if (!g_strcasecmp(label, "menu"))
          {
            if (!g_strcasecmp(value,"off"))
              preferences.menu = FALSE;
          }
          else
          {
            if (!g_strcasecmp(label, "statusbar"))
            {
              if (!g_strcasecmp(value,"off"))
                preferences.statusbar = FALSE;
            }
            else
            {
              if (!g_strcasecmp(label, "scrollbar"))
              {
                if (!g_strcasecmp(value,"off"))
                  preferences.scrollbar = FALSE;
              }
              else
              {
                if (!g_strcasecmp(label, "channel"))
                  preferences.channel = g_string_new(value);
                else
                {
                  if (!g_strcasecmp(label, "font"))
                    preferences.font = g_string_new(value);
                  else 
                  {
                    if (!g_strcasecmp(label, "backgroundcolor"))
                      gdk_color_parse(color_parse(value), 
                      &preferences.background);
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  fclose(fp);
}

/*
 * Save preferences in ~/.xconvers/preferences.The default for menu, statusbar
 * and scrollbar is 'on', so we only save it if it is 'off'.
 */
 
void savepreferences(void)
{
  gchar *preferencesfile;
  FILE *fp;

  preferencesfile = g_strconcat(preferencesdir, "/preferences", NULL);
  fp = fopen(preferencesfile, "w");
  if (fp == NULL) return;
  fprintf(fp, "# settings file for xconvers, do not edit\n");
  fprintf(fp, "version %s\n", VERSION);
  if (preferences.logging) fprintf(fp, "logging on\n");
  if (preferences.autologin) 
    {
      fprintf(fp, "autologin on\n");
      if (preferences.name) if (preferences.name->len > 0)
        fprintf(fp, "name %s\n", preferences.name->str);
      if (preferences.channel) if (preferences.channel->len > 0)
        fprintf(fp, "channel %s\n", preferences.channel->str);
    }
    
  if (!preferences.menu) fprintf(fp, "menu off\n");
  if (!preferences.statusbar) fprintf(fp, "statusbar off\n");
  if (!preferences.scrollbar) fprintf(fp, "scrollbar off\n");
  if (preferences.font) if (preferences.font->len > 0)
    fprintf(fp, "font %s\n", preferences.font->str);
  fprintf(fp, "backgroundcolor %04X,%04X,%04X\n", preferences.background.red,
    preferences.background.green, preferences.background.blue);
  fclose(fp);
}

void widget_visible(gchar *name, gboolean state)
{
  GtkWidget *widget;
  
  widget = lookup_widget(mainwindow, name);
  if (state) gtk_widget_show(widget); else gtk_widget_hide(widget);
}